% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reducers.R
\name{as_reducer}
\alias{as_reducer}
\title{Create a custom reducer}
\usage{
as_reducer(.f, ..., returns_vector = TRUE, first_match = NULL)
}
\arguments{
\item{.f}{a function that returns either a numeric vector or a \code{data.frame}}

\item{...}{Extra arguments passed to \code{.f}.}

\item{returns_vector}{logical. Does \code{.f} return a vector? \code{TRUE} by default.
If \code{FALSE}, assumes that \code{.f} returns a \code{data.frame}.}

\item{first_match}{logical. Should the partition algorithm stop when it finds
a reduction that is equal to the threshold? Default is \code{TRUE} for reducers
that return a \code{data.frame} and \code{FALSE} for reducers that return a vector}
}
\value{
a function to use in \code{\link[=as_partitioner]{as_partitioner()}}
}
\description{
Reducers are functions that tell the partition algorithm how
to reduce the data. \code{\link[=as_reducer]{as_reducer()}} is a helper function to create new
reducers to be used in \code{partitioner}s. \code{partitioner}s can be created with
\code{\link[=as_partitioner]{as_partitioner()}}.
}
\examples{

reduce_row_means <- as_reducer(rowMeans)
reduce_row_means

}
\seealso{
Other reducers: 
\code{\link{reduce_first_component}()},
\code{\link{reduce_kmeans}()},
\code{\link{reduce_scaled_mean}()}

Other reducers: 
\code{\link{reduce_first_component}()},
\code{\link{reduce_kmeans}()},
\code{\link{reduce_scaled_mean}()}
}
\concept{reducers}
