% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc-run.R
\name{pandoc_run}
\alias{pandoc_run}
\title{Run the pandoc binary from R}
\usage{
pandoc_run(args, version = "default")
}
\arguments{
\item{args}{Character vector, arguments to the pandoc CLI command}

\item{version}{Version to use. Default will be the \code{"default"} version. Other possible value are
\itemize{
\item A version number e.g \code{"2.14.1"}
\item The nightly version called \code{"nightly"}
\item The latest installed version with \code{"latest"}
\item Pandoc binary shipped with RStudio IDE with \code{"rstudio"}
\item Pandoc binary found in PATH with \code{"system"}
}}
}
\value{
The output of running \code{pandoc} binary
}
\description{
This function is a thin wrapper around the pandoc binary and allow to pass
any arguments supported by the Pandoc binary.
}
\examples{
\dontshow{if (pandoc::pandoc_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Run any command line argument (prefer `pandoc_convert()` for conversion )
pandoc::pandoc_run(c("--version"))
\dontshow{\}) # examplesIf}
\dontshow{if (!is.null(pandoc::pandoc_system_bin()) && pandoc_system_version() > "1.18") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pandoc::pandoc_run(c("--list-input-formats"), version = "system")
\dontshow{\}) # examplesIf}
}
