% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_geographic_functions.R
\name{pbdb_map_occur}
\alias{pbdb_map_occur}
\title{Plot a raster showing the number of fossil occurrences}
\usage{
pbdb_map_occur(
  data,
  res = 5,
  col_int = "white",
  col_ocean = "black",
  col_eff = c("light blue", "blue"),
  do_plot = TRUE,
  ...
)
}
\arguments{
\item{data}{Input data frame. This data frame is the output of the
\code{\link[=pbdb_occurrences]{pbdb_occurrences()}} function using the argument \code{show = "coords"}. See also Details and Examples.}

\item{res}{The resolution of the \code{SpatRaster} object (in decimal
degrees). See \code{\link[terra:dimensions]{terra::res()}}.}

\item{col_int}{The colour of the mainland.}

\item{col_ocean}{The colour of the ocean.}

\item{col_eff}{Two or more colours that are used to generate the
colour gradient showing the number of occurrences per cell in the
map.}

\item{do_plot}{Logical. If \code{TRUE}, the function produces a plot in
addition to returning a \code{SpatRaster}.}

\item{...}{Other parameters. See \code{\link[=par]{par()}} and \code{\link[maps:map]{maps::map()}}}
}
\value{
A \code{SpatRaster} object with the sampling effort (number of
fossil records per cell). This \code{SpatRaster} object has the
resolution that was specified in the \code{res} argument. The default
is \code{res = 5}. Users that wish to work with objects of this type
should load package \code{terra}.
}
\description{
Creates a \code{SpatRaster} object and a plot of the sampling
effort (number of fossil records per cell).
}
\details{
The argument \code{show = "coords"} in the \code{\link[=pbdb_occurrences]{pbdb_occurrences()}}
function is required. We recommend the use of a cairo device
(\code{\link[=X11]{X11()}}) for better visualization of the maps. See Examples.
}
\examples{
\dontrun{
  data <- pbdb_occurrences(
    limit = "all", vocab = "pbdb", base_name = "Canis", show = "coords"
  )
  X11(width = 13, height = 7.8)
  pbdb_map_occur(data, res = 2)
  ## Get the raster object without plotting it
  pbdb_map_occur(data, res = 3, do_plot = FALSE)
}
}
\seealso{
See \code{\link[=pbdb_occurrences]{pbdb_occurrences()}}, \code{\link[maps:map]{maps::map()}}, \code{\link[=par]{par()}} and \code{\link[=colors]{colors()}}
help pages
}
