% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pQTLdata.R
\docType{package}
\name{pQTLdata}
\alias{pQTLdata}
\alias{pQTLdata-package}
\title{A summary of datasets}
\description{
It aggregates protein panel data and metadata for protein quantitative trait locus (pQTL) analysis using 'pQTLtools' (\url{https://jinghuazhao.github.io/pQTLtools/}). The package includes data from affinity-based panels such as 'Olink' (\url{https://olink.com/}) and 'SomaScan' (\url{https://somalogic.com/}), as well as mass spectrometry-based panels from 'CellCarta' (\url{https://cellcarta.com/}) and 'Seer' (\url{https://seer.bio/}). The metadata encompasses updated annotations and publication details.
}
\details{
Available data are listed in the following table.\tabular{ll}{
   Objects \tab Description \cr
   \strong{Datasets} \tab   \cr
   \code{\link{caprion}} \tab Caprion panel \cr
   \code{\link{inf1}} \tab Olink/INF panel \cr
   \code{\link{Olink_Explore_1536}} \tab Olink/NGS 1472 panels \cr
   \code{\link{Olink_Explore_3072}} \tab Olink/Explore 3072 panels \cr
   \code{\link{Olink_Explore_HT}} \tab Olink/Explore HT panels \cr
   \code{\link{Olink_Target_96}} \tab Olink/Target 96 panels \cr
   \code{\link{Olink_qPCR}} \tab Olink/qPCR panels \cr
   \code{\link{SomaScan160410}} \tab SomaScan panel \cr
   \code{\link{SomaScanV4.1}} \tab SomaScan v4.1 panel \cr
   \code{\link{SomaScan11k}} \tab SomaScan 11k panel \cr
   \code{\link{scallop_inf1}} \tab SCALLOP/INF meta-analysis results \cr
   \code{\link{seer1980}} \tab ST1 from Suhre et al. (2024) bioRxiv \cr
   \code{\link{swath_ms}} \tab SWATH-MS panel \cr
   \strong{Installations} \tab   \cr
   EndNote/ \tab Proteogenomics references \cr
   Olink/ \tab Olink-COVID analysis by MGH \cr
}


Some generic description for the datasets are as follows.
\itemize{
\item chr Chromosome.
\item start Start position.
\item end End position.
\item gene Gene name.
\item UniProt UniProt ID.
}
}
\section{Usage}{

Vignettes on package usage:
\itemize{
\item An Overview of pQTLdata. \code{vignette("pQTLdata")}.
}
}

\examples{
\donttest{
# Olink-SomaScan panel overlap
p <- list(setdiff(inf1$uniprot,"P23560"),
          setdiff(SomaScan160410$UniProt[!is.na(SomaScan160410$UniProt)],"P23560"))
cnames <- c("INF1","SomaScan")
os <- VennDiagram::venn.diagram(x = p, category.names=cnames, filename=NULL,
                                disable.logging = TRUE,height=8,width=8,units="in")
grid::grid.newpage()
grid::grid.draw(os)
m <- merge(inf1,SomaScan160410,by.x="uniprot",by.y="UniProt")
u <- setdiff(with(m,unique(uniprot)),"P23560")
o <- subset(inf1,uniprot \%in\% u)
dim(o)
vars <- c("UniProt","chr","start","end","extGene","Target","TargetFullName")
s <- subset(SomaScan160410[vars], UniProt \%in\% u)
dim(s)
us <- s[!duplicated(s),]
dim(us)
us
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://jinghuazhao.github.io/pQTLdata/}
  \item \url{https://jinghuazhao.github.io/pQTLdata/}
}

}
\author{
Jing Hua Zhao in collaboration with other colleagues.
}
\keyword{internal}
