test_that("spinner_outlier_score returns expected structure", {
  X <- matrix(rnorm(100), ncol = 2)
  res <- spinner_outlier_score(X, n_spins = 50)

  expect_true(is.list(res))
  expect_length(res$score, nrow(X))
  expect_equal(ncol(res$dim_contrib_norm), ncol(X))
})

test_that("scores are non-negative", {
  X <- matrix(rnorm(100), ncol = 2)
  res <- spinner_outlier_score(X, n_spins = 50)
  expect_true(all(res$score >= 0))
})
