% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_c_correlation.R
\encoding{UTF-8}
\name{total_c_correlation}
\alias{total_c_correlation}
\title{Computes the total cumulative correlation of an ordinal time series}
\usage{
total_c_correlation(series, lag = 1, states, features = FALSE)
}
\arguments{
\item{series}{An OTS.}

\item{lag}{The considered lag (default is 1).}

\item{states}{A numerical vector containing the corresponding
states.}

\item{features}{Logical. If \code{features = FALSE} (default), the value of the total cumulative correlation is returned. Otherwise, the function
returns a matrix with the individual components of the total cumulative correlation}
}
\value{
If \code{features = FALSE} (default), returns the value of the total cumulative correlation. Otherwise, the function
returns a matrix of features, i.e., the matrix contains the features employed to compute the
total cumulative correlation.
}
\description{
\code{total_c_correlation} returns the value of the total cumulative correlation for
an ordinal time series
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, \ldots, s_n\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, and
the cumulative binarized time series, which is defined as
\eqn{\overline{\boldsymbol Y}_t=\{\overline{\boldsymbol Y}_1, \ldots, \overline{\boldsymbol Y}_T\}},
with \eqn{\overline{\boldsymbol Y}_k=(\overline{Y}_{k,0}, \ldots, \overline{Y}_{k,n-1})^\top}
such that \eqn{\overline{Y}_{k,i}=1} if \eqn{\overline{X}_k\leq s_i} (\eqn{k=1,\ldots,T,
, i=0,\ldots,n-1}), the function computes the estimated average \eqn{\widehat{\Psi}(l)^c=\frac{1}{n^2}\sum_{i,j=0}^{n-1}\widehat{\psi}_{ij}(l)^2},
where \eqn{\widehat{\psi}_{ij}(l)} is the estimated correlation
\eqn{\widehat{Corr}(Y_{t, i}, Y_{t-l, j})}, \eqn{i,j=0, 1,\ldots,n-1}. If \code{features = TRUE}, the function
returns a matrix whose components are the quantities \eqn{\widehat{\psi}_{ij}(l)},
\eqn{i,j=0,1, \ldots,n-1}.
}
\examples{
tcc <- total_c_correlation(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the total cumulative correlation
# for one of the series in dataset AustrianWages
feature_matrix <- total_c_correlation(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the corresponding matrix of features
}
\author{
Ángel López-Oriona, José A. Vilar
}
