% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp_create_surface.R
\name{otp_create_surface}
\alias{otp_create_surface}
\title{Creates a travel time surface (OTPv1 only).}
\usage{
otp_create_surface(
  otpcon,
  getRaster = FALSE,
  rasterPath = tempdir(),
  fromPlace,
  mode = "TRANSIT",
  date = format(Sys.Date(), "\%m-\%d-\%Y"),
  time = format(Sys.time(), "\%H:\%M:\%S"),
  maxWalkDistance = NULL,
  walkReluctance = 2,
  waitReluctance = 1,
  transferPenalty = 0,
  minTransferTime = 0,
  batch = TRUE,
  arriveBy = TRUE,
  extra.params = list()
)
}
\arguments{
\item{otpcon}{An OTP connection object produced by \code{\link{otp_connect}}.}

\item{getRaster}{Logical. Whether or not to download a raster (geoTIFF) of the generated
surface. Default FALSE.}

\item{rasterPath}{Character. Path of a directory where the the surface raster
should be saved if \code{getRaster} is TRUE. Default is \code{tempdir()}. Use forward slashes on Windows.
The file will be named surface_{id}.tiff, with {id} replaced by the OTP id assigned
to the surface.}

\item{fromPlace}{Numeric vector, Latitude/Longitude pair, e.g. `c(53.48805, -2.24258)`. This is
the origin of the surface to be created.}

\item{mode}{Character vector, mode(s) of travel. Valid values are: WALK, BICYCLE,
CAR, TRANSIT, BUS, RAIL, TRAM, SUBWAY OR 'c("TRANSIT", "BICYCLE")'. TRANSIT will use all
available transit modes. Default is CAR. WALK mode is automatically
added for TRANSIT, BUS, RAIL, TRAM, and SUBWAY.}

\item{date}{Character, must be in the format mm-dd-yyyy. This is the desired date of travel.
Only relevant for transit modes. Default is the current system date.}

\item{time}{Character, must be in the format hh:mm:ss.
If \code{arriveBy} is FALSE (the default) this is the desired departure time, otherwise the
desired arrival time. Only relevant for transit modes. Default is the current system time.}

\item{maxWalkDistance}{Numeric. The maximum distance (in meters) that the user is
willing to walk. Default is NULL (the parameter is not passed to the API and the OTP
default of unlimited takes effect).
This is a soft limit in OTPv1 and is ignored if the mode is WALK only. In OTPv2
this parameter imposes a hard limit on WALK, CAR and BICYCLE modes (see:
\url{http://docs.opentripplanner.org/en/latest/OTP2-MigrationGuide/#router-config}).}

\item{walkReluctance}{A single numeric value. A multiplier for how bad walking is
compared to being in transit for equal lengths of time. Default = 2.}

\item{waitReluctance}{A single numeric value. A multiplier for how bad waiting for a
transit vehicle is compared to being on a transit vehicle. This should be greater
than 1 and less than \code{walkReluctance} (see API docs). Default = 1.}

\item{transferPenalty}{Integer. An additional penalty added to boardings after
the first. The value is in OTP's internal weight units, which are roughly equivalent to seconds.
Set this to a high value to discourage transfers. Default is 0.}

\item{minTransferTime}{Integer. The minimum time, in seconds, between successive
trips on different vehicles. This is designed to allow for imperfect schedule
adherence. This is a minimum; transfers over longer distances might use a longer time.
Default is 0.}

\item{batch}{Logical. Set to TRUE by default. This is required to tell OTP
to allow a query without the  \code{toPlace} parameter. This is necessary as we want to build
paths to all destinations from one origin.}

\item{arriveBy}{Logical. Whether a trip should depart (FALSE) or arrive (TRUE) at the specified
date and time. Default is FALSE.}

\item{extra.params}{A list of any other parameters accepted by the OTP API SurfaceResource entry point. For
advanced users. Be aware that otpr will carry out no validation of these additional
parameters. They will be passed directly to the API.}
}
\value{
Assuming no error, returns a list of 5 elements:
\itemize{
\item \code{errorId} Will be "OK" if no error condition.
\item \code{surfaceId} The id of the surface that was evaluated.
\item \code{surfaceRecord} Details of the parameters used to create the surface.
\item \code{rasterDownload} The path to the saved raster file (if \code{getRaster} was
set to TRUE and a valid path was provided via \code{rasterPath}.)
\item \code{query} The URL that was submitted to the OTP API.
}
If there is an error, a list containing 3 elements is returned:
\itemize{
\item \code{errorId} The id code of the error.
\item \code{errorMessage} The error message.
\item \code{query} The URL that was submitted to the OTP API.
}
}
\description{
Creates a travel time surface for an origin point. A surface contains the travel time
to every geographic coordinate that can be reached from that origin (up to a hard coded
limit in OTP of 120 minutes). Optionally, the surface can be saved as a raster file (GeoTIFF)
to a designated directory.
}
\details{
There are a few things to note regarding the raster image that OTP creates:
\itemize{
\item The travel time cutoff for a surface is hard-coded within OTP at 120 minutes. Every grid
 cell within the extent of the graph that is 120 minutes travel time or beyond, or not accessible,
 is given the value of 120.
\item Any grid cell outside of the extent of the network (i.e. unreachable) is given the value 128.
\item It is advisable to interpret the raster of a surface in conjunction with results from 
evaluating the surface.
\item OTP can take a while the first time a raster of a surface is generated after starting up. Subsequent
rasters (even for different origins) are much faster to generate.
}
}
\examples{
\dontrun{
otp_create_surface(otpcon, fromPlace = c(53.43329,-2.13357), mode = "TRANSIT",
maxWalkDistance = 1600, getRaster = TRUE)

otp_create_surface(otpcon, fromPlace = c(53.43329,-2.13357), date = "03-26-2019",
time = "08:00:00", mode = "BUS", maxWalkDistance = 1600, getRaster = TRUE,
rasterPath = "C:/temp")
}
}
