% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.objects.summary.R
\name{print.objects.summary}
\alias{print.objects.summary}
\title{Print Method for \code{objects.summary} Objects}
\usage{
\method{print}{objects.summary}(
  x,
  ...,
  data.class.width = getOption("osum.data.class.width", default = NULL),
  format.extent = getOption("osum.format.extent", default = TRUE),
  max.rows = getOption("osum.max.rows", default = NULL)
)
}
\arguments{
\item{x}{object of class \code{objects.summary}}

\item{...}{further arguments to be passed down to \code{print.data.frame} (should not include \code{max})}

\item{data.class.width}{integer indicating the width of the \code{data.class} field when
it is a list (when \code{objects.summary} was called with \code{all.classes} = \code{TRUE}).
Default: getOption("osum.data.class.width", default = NULL)}

\item{format.extent}{logical indicating whether the \code{extent} field should be formatted as
product (d1 x d2) or left as list (d1, d2). Default: getOption("osum.format.extent", default = TRUE)}

\item{max.rows}{integer, maximal number of rows to print. Default: getOption("osum.max.rows", default = NULL)}
}
\value{
No return value, called for side effects.
}
\description{
Print an object of class \code{objects.summary} with some specific formatting
options before using \code{print.data.frame}.
}
\details{
\code{max.rows} computes an adequate value to be passed as \code{max} argument to \code{print.data.frame}.
By default, when NULL, getOption("max.print") is used by \code{print.data.frame}.
}
\examples{
print(objects.summary("package:datasets", all.classes = FALSE),
    format.extent = FALSE, max.rows = 6)
print(objects.summary("package:datasets", all.classes = TRUE, data.class = "array"),
    data.class.width = 22, format.extent = TRUE, max.rows = 6)
}
\seealso{
\code{\link{objects.summary}}, \code{\link{print.data.frame}}
}
