% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names_api.R
\name{query_nearest_names}
\alias{query_nearest_names}
\title{Query the OS Names API}
\usage{
query_nearest_names(
  point,
  radius = 100,
  local_type,
  key = get_os_key(),
  returnType = c("geojson", "list", "sf"),
  ...
)
}
\arguments{
\item{point}{A set of British National Grid coordinates (EPSG:27700). Can be
a set of coordinates as a numeric vector, an object of class \code{geos},
or an object of class \code{sf}.}

\item{radius}{(numeric) The search radius in metres (max. 1000). Default is
100.}

\item{local_type}{(character) Filters the results to certain local types. The
available local types can be found at:
\url{https://osdatahub.os.uk/docs/names/technicalSpecification}.}

\item{key}{(character) OS API key. Default action is to search for an
environment variable using \code{get_os_key()}.}

\item{returnType}{(character) Return the query results as the raw
\code{'geojson'}, a nested \code{'list'} object containing the returns,
or convert them into Simple Features and return an object of class
\code{'sf'}.}

\item{...}{Additional parameters (not currently used).}
}
\value{
A GeoJSON string with the results of the API query, a list object,
or an object of class \code{sf} based on the \code{returnType} parameter.
}
\description{
Takes a pair of coordinates (X, Y) as an input to determine the closest name
from a geographic directory of identifiable places.
}
\details{
The OS Names API is a geographic directory containing basic
information about identifiable places. Use this function to query Names to
find the nearest named place to a given point location.

Within OS Names, place names aren’t unique. Extra location details are
provided to help users refine their queries and accurately identify the
named place they’re interested in. These details include postcode district,
populated place, district/borough, county/unitary authority, European
region and country. Queries can also be refined by supplying bounding boxes
or local types to search.

Technical details on the Names API are documented on the Data Hub:
\url{https://osdatahub.os.uk/docs/names/technicalSpecification}.
}
\examples{
\dontshow{if (has_os_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Named entity nearest to a point location
results <- query_nearest_names(point = c(440200,449300))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=query_names]{query_names()}}, \link{extent}
}
