% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extent.R
\name{extent}
\alias{extent}
\alias{extent_from_bbox}
\alias{extent_from_polygon}
\alias{extent_from_geojson}
\alias{extent_from_radius}
\alias{extent_from_bng}
\title{Create extents from geometries}
\usage{
extent_from_bbox(bbox, crs = "crs84", returnType = c("qExtent", "geos", "wkt"))

extent_from_polygon(
  polygon,
  crs = "crs84",
  returnType = c("qExtent", "geos", "wkt")
)

extent_from_geojson(
  geojson,
  crs = "crs84",
  returnType = c("qExtent", "geos", "wkt")
)

extent_from_radius(
  centre,
  radius,
  crs = "epsg:27700",
  returnType = c("qExtent", "geos", "wkt")
)

extent_from_bng(grid_ref, returnType = c("qExtent", "geos", "wkt"))
}
\arguments{
\item{bbox}{A bounding box, passed as a numeric vector in
(xmin,ymin,xmax,ymax) format, or a \code{data.frame} object with numeric
columns.}

\item{crs}{(character or numeric)  The identifier for coordinate reference
system information for the feature, either in the format "epsg:xxxx" or an
EPSG number. e.g. British National Grid can be supplied as "epsg:27700" or
27700. Available CRS values are: EPSG:27700, EPSG:4326, EPSG:7405,
EPSG:3857, and CRS84. Defaults to CRS84.}

\item{returnType}{(character) Define the object returned. The default is
\code{'qExtent'} to define a "query extent" object expected internally by
\code{osdatahub}. Other options are \code{'wkt'} to return the geometry in
Well-Known Text format or \code{'geos'} to return an object of class
\code{geos}.}

\item{polygon}{A polygon specified in a WKT string, an object of class
\code{geos}, or an object of class \code{sf}.}

\item{geojson}{A character string defining a polygon in GeoJSON format.}

\item{centre}{Either a numeric vector with coordinates in the form (x, y), a
Point object in a WKT string, a Point as a \code{geos} geometry or an
object of class \code{sf}.}

\item{radius}{(numeric) The radius of the circle in meters.}

\item{grid_ref}{A character string with a British National Grid reference.
The extent is formed by the grid square of the reference.}
}
\value{
The coordinates of the polygon boundary as defined by
\code{returnType}.
}
\description{
Provide extents from various types of input features and geometries to be
used as filters in OS Data Hub API queries.
}
\details{
When defining an extent by a radius around a point, the CRS must be
either 'epsg:27700' or 'epsg:3857' which implies the units of the distance
for the radius are meters.

Using \code{crs}='epsg:4326' implies that coordinates will be in
Latitude/Longitude order. The equivalent projection with Longitude/Latitude
order is 'crs84'.

The \code{qExtent} return option identifies a simple class of objects
containing a polygon of the extent in WKT format, the bounding box
coordinates, and a CRS string. It is intended to be used internally by
functions in \code{osdatahub}.
}
\examples{
extent_from_bbox(c(600000, 310200, 600900, 310900), "epsg:27700", returnType = 'wkt')

# When using EPSG:4326, note the coordinate order expects latitude, longitude
extent_from_bbox(c(50.928731, -1.503346, 50.942376, -1.46762), crs="epsg:4326")

extent_from_radius(c(441317, 112165), radius = 200)

extent_from_bng("SU3715")

}
