# test of Agresti 1983

#' Test of methods in Agresti (1983). Testing marginal homogeneity for ordinal categorical
#' variables.
#'
#' Note that Agresti gives 0.046 for sigma and 3.65 fot z.
test_that("Agresti tau is correct", {
  n <- vision_data
  result <- Agresti_weighted_tau(n)
  message(result)
  expect_true(abs(0.0169 - result$tau) <= 0.00005)
  expect_true(abs(0.0049 - result$sigma_tau) <= 0.00005)
  expect_true(abs(3.45 - result$z_tau) <= 0.005)
}
)

test_that("Agresti location and dispersion work", {
  n <- vision_data
  row <- rowSums(n)
  col <- colSums(n)
  k = length(row)
  x <- rep(0.0, k^2)
  y <- rep(0.0, k^2)
  w <- rep(0.0, k^2)
  index <- 0
  for (i in 1:k) {
    for (j in 1:k) {
      index <- index + 1
      y[index] <- i
      x[index] <- j
      w[index] <- n[i, j]
    }
  }

  disp_w <- c(1, -1, -1, 1)
  loc_w <- c(3, 1, -1, -3)
  w_diff_loc <- Agresti_w_diff(loc_w, n)
  w_diff_disp <- Agresti_w_diff(disp_w, n)
  testthat_tolerance()
  expect_true(abs(w_diff_loc$diff - 0.0599) <= 0.00005)
  expect_true(abs(w_diff_loc$sigma_diff - 0.0173) <= 0.00005)
  expect_true(abs(w_diff_loc$z_diff - 3.46) <= 0.005)

  expect_true(abs(w_diff_disp$diff - 0.0045) <= 0.00005)
  expect_true(abs(w_diff_disp$sigma_diff - 0.0096) <= 0.00005)
  expect_true(abs(w_diff_disp$z_diff - 0.4742) <= 0.00005)
}
)
