% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location.R
\name{orderly_location_list}
\alias{orderly_location_list}
\title{List known pack locations}
\usage{
orderly_location_list(verbose = FALSE, root = NULL)
}
\arguments{
\item{verbose}{Logical, indicating if we should return a
data.frame that includes more information about the location.}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
Depending on the value of \code{verbose}:
\itemize{
\item \code{verbose = FALSE}: A character vector of location names.  This is the
default behaviour.
\item \code{verbose = TRUE}: A data.frame with columns \code{name}, \code{type} and
\code{args}.  The \code{args} column is a list column, with each element
being the key-value pair arguments to the location.
}
}
\description{
List known locations.  The special name \code{local} will always be
present within the output from this function (this is packets
known at the current root), though you will typically be
interested in \emph{other} locations.
}
\examples{
# Two roots, one local and one representing some remote orderly location:
local <- orderly_example()
remote <- orderly_example()

# No locations at first
orderly_location_list(root = local)

# Add a location
orderly_location_add_path("remote", remote, root = local)

# Here it is!
orderly_location_list(root = local)

# Add vebose = TRUE to find more about the location
orderly_location_list(root = local)
}
\seealso{
\code{\link[=orderly_location_fetch_metadata]{orderly_location_fetch_metadata()}}, which can
update your outpack index with metadata from any of the
locations listed here.
}
