% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-person.R
\name{orcid_researcher_urls}
\alias{orcid_researcher_urls}
\title{Retrieve researcher URLs from ORCID}
\usage{
orcid_researcher_urls(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{put_code}{Unique identifier for this URL}
\item{url_name}{Name/label for the URL}
\item{url_value}{The actual URL}
}
Returns an empty data.table with the same structure if no URLs
are found.
}
\description{
Fetches professional and personal URLs associated with an ORCID record,
such as personal websites, institutional profiles, social media, etc.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/researcher-urls}
}
\examples{
\dontrun{
# Fetch researcher URLs
urls <- orcid_researcher_urls("0000-0002-1825-0097")
print(urls)
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_person}}, \code{\link{orcid_external_identifiers}}
}
