% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.optcheck.R
\name{print.optcheck}
\alias{print.optcheck}
\alias{print.summary.optcheck}
\alias{print.optproj}
\alias{print.summary.optproj}
\alias{print.optrefit}
\alias{print.summary.optrefit}
\title{Print method for \code{optcheck} and \code{summary.optcheck} objects.}
\usage{
\method{print}{optcheck}(x, digits = max(3L, getOption("digits") - 3L), n = 5L, ...)

\method{print}{summary.optcheck}(x, digits = max(3L, getOption("digits") - 3L), n = 5L, ...)
}
\arguments{
\item{x}{Object of class \code{optcheck} or \code{summary.optcheck}, currently returned by \code{\link[=optim_proj]{optim_proj()}}, \code{\link[=optim_refit]{optim_refit()}}, or a summary of either of those calls.}

\item{digits}{Number of digits to display.}

\item{n}{Number of elements of solution vector to display (see Details).}

\item{...}{Further arguments to be passed to or from other methods.}
}
\value{
Invisibly \code{x} itself.
}
\description{
Print method for \code{optcheck} and \code{summary.optcheck} objects.
}
\details{
The \code{print} methods for \code{optcheck} and \code{summary.optcheck} objects both display three-column matrix, consisting of the potential solution (\code{xsol}), the absolute difference between it and the optimal solution (\code{xopt}) return by either \code{\link[=optim_proj]{optim_proj()}} and \code{\link[=optim_refit]{optim_refit()}}, and the relative difference (\verb{R = (xopt - xsol)/|xsol|}).  Only the elemnts corresponding to the top-\code{n} relative differences are displayed.
}
