% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassModel.R
\name{load_model}
\alias{load_model}
\alias{OpenMppModel}
\title{OpenM++ Model Class}
\usage{
load_model(model)
}
\arguments{
\item{model}{Model digest or model name.}
}
\value{
An \code{OpenMppModel} instance.
}
\description{
OpenM++ Model Class
}
\examples{
\dontrun{
use_OpenMpp_local()
load_model("RiskPaths")
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{OpenMppType}}{OpenM++ object type (used for \code{print()} method).}

\item{\code{ModelDigest}}{Model digest.}

\item{\code{ModelName}}{Model name.}

\item{\code{ModelVersion}}{Model version.}

\item{\code{ModelMetadata}}{Model metadata.}

\item{\code{ParamsInfo}}{Input parameter information.}

\item{\code{TablesInfo}}{Output table information.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{ModelWorksets}}{Data frame of worksets.}

\item{\code{ModelScenarios}}{Data frame of scenarios.}

\item{\code{ModelRuns}}{Data frame of model runs.}

\item{\code{ModelTasks}}{Data frame of model tasks.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OpenMppModel-new}{\code{OpenMppModel$new()}}
\item \href{#method-OpenMppModel-print}{\code{OpenMppModel$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModel-new"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModel-new}{}}}
\subsection{Method \code{new()}}{
Create a new OpenMppModel object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModel$new(model)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{Model digest or name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{OpenMppModel} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenMppModel-print"></a>}}
\if{latex}{\out{\hypertarget{method-OpenMppModel-print}{}}}
\subsection{Method \code{print()}}{
Print a OpenMppModel object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenMppModel$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not currently used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
}
