% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-salinity.R
\docType{data}
\name{salinity}
\alias{salinity}
\title{Salinity in Bimini Lagoon, Bahamas}
\format{
A data frame with 30 rows and 2 variables.
\describe{
\item{site_number}{Location where measurements were taken.}
\item{salinity_ppt}{Salinity value in parts per thousand.}
}
}
\source{
Till, R. (1974) Statistical Methods for the Earth Scientist: An Introduction. London: Macmillon, 104.
}
\usage{
salinity
}
\description{
Data collected at three different water masses in the Bimini Lagoon, Bahamas.
}
\examples{
library(ggplot2)
library(broom)

ggplot(salinity, aes(x = salinity_ppt)) +
  geom_dotplot() +
  facet_wrap(~site_number, ncol = 1)

tidy(aov(salinity_ppt ~ site_number, data = salinity))
}
\keyword{datasets}
