% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpp.R
\name{rpp}
\alias{rpp}
\title{Generate Random Counts from a Zero-Truncated Poisson Process}
\usage{
rpp(b, X)
}
\arguments{
\item{b}{A numeric vector of coefficients for the rate component.}

\item{X}{A matrix or data frame of predictor variables for the rate component.}
}
\value{
A numeric vector of simulated count data.
}
\description{
Simulates count data from a zero-truncated Poisson process using specified parameters 
for the rate component.
}
\details{
This function generates count data from a zero-truncated Poisson process, which models 
count data without zeros. The process involves:
\itemize{
  \item Calculating the rate parameter (\eqn{\lambda}) as \eqn{\exp(X \cdot b)}.
  \item Iteratively computing probabilities for counts starting from 1 and adding to the cumulative 
    probability until a randomly drawn value is matched.
}

This function is useful for generating synthetic data for testing or simulation studies involving 
zero-truncated Poisson models.
}
\examples{
# Example usage
set.seed(123)
X <- matrix(rnorm(100), ncol = 2)
b <- c(0.5, -0.2)
simulated_data <- rpp(b, X)
print(simulated_data)

}
\seealso{
\code{\link{truncreg}} for fitting zero-truncated models.
}
