% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_table.R
\name{span_table}
\alias{span_table}
\title{Spread Large Table Over Smaller Tables}
\usage{
span_table(
  table_body = NULL,
  row_common = NULL,
  table_body_head = NULL,
  row_common_head = NULL,
  header_format = "text",
  obnd = NULL,
  max_row = 20,
  max_col = 10,
  max_height = 7,
  max_width = 6.5,
  table_alignment = "center",
  inner_border = officer::fp_border(color = "black", width = 0.3),
  outer_border = officer::fp_border(color = "black", width = 2),
  set_header_inner_border_v = TRUE,
  set_header_inner_border_h = TRUE,
  set_header_outer_border = TRUE,
  set_body_inner_border_v = TRUE,
  set_body_inner_border_h = FALSE,
  set_body_outer_border = TRUE,
  notes_detect = NULL
)
}
\arguments{
\item{table_body}{Data frame with the body of the large table.}

\item{row_common}{Data frame with the common rows.}

\item{table_body_head}{Data frame or matrix with headers for the table body.}

\item{row_common_head}{Data frame or matrix with headers for the common rows.}

\item{header_format}{Format of the header either \code{"text"} (default) or \code{"md"} for markdown.}

\item{obnd}{Optional onbrand object used to format markdown. The default \code{NULL} value will use default formatting.}

\item{max_row}{Maximum number of rows in output tables (A value of \code{NULL} will set max_row to the number of rows in the table).}

\item{max_col}{Maximum number of columns in output tables (A value of \code{NULL} will set max_col to number of columns in the table).}

\item{max_height}{Maximum height of the final table in inches (A value of \code{NULL} will use 100 inches).}

\item{max_width}{Maximum width of the final table in inches (A value of \code{NULL} will use 100 inches).}

\item{table_alignment}{Character string specifying the alignment #'of the table (body and headers). Can be \code{"center"} (default), \code{"left"}, \code{"right"}, or \code{"justify"}}

\item{inner_border}{Border object for inner border lines defined using \code{officer::fp_border()}}

\item{outer_border}{Border object for outer border lines defined using \code{officer::fp_border()}}

\item{set_header_inner_border_v}{Boolean value to enable or disable inner vertical borders for headers}

\item{set_header_inner_border_h}{Boolean value to enable or disable inner horizontal borders for headers}

\item{set_header_outer_border}{Boolean value to enable or disable outer border for headers}

\item{set_body_inner_border_v}{Boolean value to enable or disable inner vertical borders for the body}

\item{set_body_inner_border_h}{Boolean value to enable or disable inner horizontal borders for the body}

\item{set_body_outer_border}{Boolean value to enable or disable outer border borders for the body}

\item{notes_detect}{Vector of strings to detect in output tables (example \code{c("NC", "BLQ")}).}
}
\value{
list with the following elements
\itemize{
  \item{isgood:}    Boolean indicating the exit status of the function.
  \item{one_body:}  Full table with no headers.
  \item{one_table:} Full table with headers.
  \item{msgs:}      Vector of text messages describing any errors that were found.
  \item{tables:}    Named list of tables. Each list element is of the output.
  format from \code{build_span()}.
}
}
\description{
Takes a large table and spreads it over smaller tables to
paginate it. It will preserve common row  information on the left and
separate columns according to maximum specifications. The final tables will
have widths less than or equal to both max_col and max_width, and heights
less than or equal to both max_row and max_height.
}
\details{
The way the data frames relate to each other are mapped out below. The
dimensions of the different data frames are identified below (nrow x ncol)


\preformatted{
 |-------------------------------------| ---
 |                 |                   |  ^
 |                 |                   |  |
 | row_common_head |  table_body_head  |  | m
 |      m x n      |       m x c       |  |
 |                 |                   |  v
 |-------------------------------------| ---
 |                 |                   |  ^
 |                 |                   |  |
 |    row_common   |    table_body     |  | r
 |      r x n      |      r x c        |  |
 |                 |                   |  |
 |                 |                   |  v
 |-------------------------------------| ---

 |<--------------->|<----------------->|
         n                   c
}
}
\examples{
if(interactive()){

tbl_res = mk_lg_tbl()

res =
span_table(table_body      = tbl_res$lg_tbl_body,
           row_common      = tbl_res$lg_tbl_row_common,
           table_body_head = tbl_res$lg_tbl_body_head,
           row_common_head = tbl_res$lg_tbl_row_common_head,
           max_row         = 20,
           max_col         = 10,
           notes_detect    = c("BQL", "NC"))


# Notes detected in the first table:
res[["tables"]][["Table 1"]][["notes"]]

# First table as a data frame:
res[["tables"]][["Table 1"]][["df"]]

# First table as a flextable:
res[["tables"]][["Table 1"]][["ft"]]

}

}
\seealso{
\code{\link{build_span} for the relationship of inputs.}
}
