% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_template.R
\name{read_template}
\alias{read_template}
\title{Read Word or PowerPoint Templates}
\usage{
read_template(
  template = file.path(system.file(package = "onbrand"), "templates", "report.pptx"),
  mapping = file.path(system.file(package = "onbrand"), "templates", "report.yaml"),
  verbose = TRUE
)
}
\arguments{
\item{template}{Name of PowerPoint or Word file to annotate (defaults to included PowerPoint template)}

\item{mapping}{Name of yaml file with configuration information}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal; Messages will be included in the returned onbrand
object.}
}
\value{
onbrand object which is a list with the following elements:
\itemize{
\item{isgood}:       Boolean variable indicating the current state of the object
\item{rpt}:          Officer object containing the initialized report
\item{rpttype}:      Type of report (either PowerPoint or Word)
\item{key_table}:    Empty (NULL) mapping table for tracking cross referencing (Word only)
\item{placeholders}: Empty list to hold placeholder substitution text (Word only)
\item{meta}:         Metadata read in from the yaml file
\item{mapping}:      Mapping yaml file
\item{msgs}:         Vector of messages indicating any errors that were encountered
}
}
\description{
Takes a given template file/yaml mapping file combination, reads in
that information, checks to make sure the mapping information is correct and
then returns an onbrand object.
}
\examples{
obnd = read_template(
      template = file.path(system.file(package="onbrand"), "templates", "report.pptx"),
      mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))

obnd = read_template(
      template = file.path(system.file(package="onbrand"), "templates", "report.docx"),
      mapping  = file.path(system.file(package="onbrand"), "templates", "report.yaml"))

}
