% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{SearchResource}
\alias{SearchResource}
\title{Search Resource}
\value{
Search results with pagination.

A tibble of all matching concepts.

Search results with facets and metadata.

Autocomplete suggestions.

List with results and pagination metadata.

A tibble of all matching concepts with similarity scores.

List with similar_concepts and search_metadata.
}
\description{
R6 class providing access to search operations.
}
\note{
When algorithm='semantic', only single vocabulary/domain filter supported.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SearchResource-new}{\code{SearchResource$new()}}
\item \href{#method-SearchResource-basic}{\code{SearchResource$basic()}}
\item \href{#method-SearchResource-basic_all}{\code{SearchResource$basic_all()}}
\item \href{#method-SearchResource-advanced}{\code{SearchResource$advanced()}}
\item \href{#method-SearchResource-autocomplete}{\code{SearchResource$autocomplete()}}
\item \href{#method-SearchResource-semantic}{\code{SearchResource$semantic()}}
\item \href{#method-SearchResource-semantic_all}{\code{SearchResource$semantic_all()}}
\item \href{#method-SearchResource-similar}{\code{SearchResource$similar()}}
\item \href{#method-SearchResource-print}{\code{SearchResource$print()}}
\item \href{#method-SearchResource-clone}{\code{SearchResource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-new"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-new}{}}}
\subsection{Method \code{new()}}{
Create a new SearchResource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$new(base_req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_req}}{Base httr2 request object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-basic"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-basic}{}}}
\subsection{Method \code{basic()}}{
Basic concept search.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$basic(
  query,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  concept_class_ids = NULL,
  standard_concept = NULL,
  include_synonyms = FALSE,
  include_invalid = FALSE,
  min_score = NULL,
  exact_match = FALSE,
  page = 1,
  page_size = 20,
  sort_by = NULL,
  sort_order = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Search query string.}

\item{\code{vocabulary_ids}}{Filter by vocabulary IDs.}

\item{\code{domain_ids}}{Filter by domain IDs.}

\item{\code{concept_class_ids}}{Filter by concept class IDs.}

\item{\code{standard_concept}}{Filter by standard concept ("S", "C", or NULL).}

\item{\code{include_synonyms}}{Search in synonyms. Default \code{FALSE}.}

\item{\code{include_invalid}}{Include invalid concepts. Default \code{FALSE}.}

\item{\code{min_score}}{Minimum relevance score.}

\item{\code{exact_match}}{Require exact match. Default \code{FALSE}.}

\item{\code{page}}{Page number (1-based). Default 1.}

\item{\code{page_size}}{Results per page. Default 20.}

\item{\code{sort_by}}{Sort field.}

\item{\code{sort_order}}{Sort order ("asc" or "desc").}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-basic_all"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-basic_all}{}}}
\subsection{Method \code{basic_all()}}{
Fetch all search results with automatic pagination.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$basic_all(
  query,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  page_size = 100,
  max_pages = Inf,
  progress = TRUE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Search query string.}

\item{\code{vocabulary_ids}}{Filter by vocabulary IDs.}

\item{\code{domain_ids}}{Filter by domain IDs.}

\item{\code{page_size}}{Results per page. Default 100.}

\item{\code{max_pages}}{Maximum pages to fetch. Default Inf.}

\item{\code{progress}}{Show progress bar. Default \code{TRUE}.}

\item{\code{...}}{Additional search parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-advanced"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-advanced}{}}}
\subsection{Method \code{advanced()}}{
Advanced concept search with facets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$advanced(
  query,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  concept_class_ids = NULL,
  standard_concepts_only = FALSE,
  include_invalid = FALSE,
  relationship_filters = NULL,
  page = 1,
  page_size = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Search query string.}

\item{\code{vocabulary_ids}}{Filter by vocabulary IDs.}

\item{\code{domain_ids}}{Filter by domain IDs.}

\item{\code{concept_class_ids}}{Filter by concept class IDs.}

\item{\code{standard_concepts_only}}{Only return standard concepts. Default \code{FALSE}.}

\item{\code{include_invalid}}{Include invalid concepts. Default \code{FALSE}.}

\item{\code{relationship_filters}}{Relationship-based filters.}

\item{\code{page}}{Page number (1-based). Default 1.}

\item{\code{page_size}}{Results per page. Default 20.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-autocomplete"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-autocomplete}{}}}
\subsection{Method \code{autocomplete()}}{
Get autocomplete suggestions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$autocomplete(
  query,
  vocabulary_ids = NULL,
  domains = NULL,
  max_suggestions = 10
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Partial query string.}

\item{\code{vocabulary_ids}}{Filter by vocabulary IDs.}

\item{\code{domains}}{Filter by domains.}

\item{\code{max_suggestions}}{Maximum suggestions. Default 10.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-semantic"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-semantic}{}}}
\subsection{Method \code{semantic()}}{
Semantic concept search using neural embeddings.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$semantic(
  query,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  standard_concept = NULL,
  concept_class_id = NULL,
  threshold = NULL,
  page = 1,
  page_size = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Natural language search query (required).}

\item{\code{vocabulary_ids}}{Filter by vocabulary IDs.}

\item{\code{domain_ids}}{Filter by domain IDs.}

\item{\code{standard_concept}}{Filter by standard concept ('S' or 'C').}

\item{\code{concept_class_id}}{Filter by concept class ID.}

\item{\code{threshold}}{Minimum similarity threshold (0.0-1.0, default 0.5).}

\item{\code{page}}{Page number (1-based). Default 1.}

\item{\code{page_size}}{Results per page (max 100). Default 20.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-semantic_all"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-semantic_all}{}}}
\subsection{Method \code{semantic_all()}}{
Fetch all semantic search results with automatic pagination.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$semantic_all(
  query,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  standard_concept = NULL,
  concept_class_id = NULL,
  threshold = NULL,
  page_size = 100,
  max_pages = Inf,
  progress = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Natural language search query (required).}

\item{\code{vocabulary_ids}}{Filter by vocabulary IDs.}

\item{\code{domain_ids}}{Filter by domain IDs.}

\item{\code{standard_concept}}{Filter by standard concept ('S' or 'C').}

\item{\code{concept_class_id}}{Filter by concept class ID.}

\item{\code{threshold}}{Minimum similarity threshold (0.0-1.0).}

\item{\code{page_size}}{Results per page. Default 100.}

\item{\code{max_pages}}{Maximum pages to fetch. Default Inf.}

\item{\code{progress}}{Show progress bar. Default \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-similar"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-similar}{}}}
\subsection{Method \code{similar()}}{
Find concepts similar to a reference concept or query.

Must provide exactly one of: concept_id, concept_name, or query.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$similar(
  concept_id = NULL,
  concept_name = NULL,
  query = NULL,
  algorithm = "hybrid",
  similarity_threshold = 0.7,
  page_size = 20,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  standard_concept = NULL,
  include_invalid = NULL,
  include_scores = NULL,
  include_explanations = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_id}}{Concept ID to find similar concepts for.}

\item{\code{concept_name}}{Concept name to find similar concepts for.}

\item{\code{query}}{Natural language query for semantic similarity.}

\item{\code{algorithm}}{One of 'semantic', 'lexical', or 'hybrid' (default).}

\item{\code{similarity_threshold}}{Minimum similarity (0.0-1.0). Default 0.7.}

\item{\code{page_size}}{Max results (max 1000). Default 20.}

\item{\code{vocabulary_ids}}{Filter by vocabulary IDs.}

\item{\code{domain_ids}}{Filter by domain IDs.}

\item{\code{standard_concept}}{Filter by standard concept flag ('S', 'C', or 'N').}

\item{\code{include_invalid}}{Include invalid/deprecated concepts.}

\item{\code{include_scores}}{Include detailed similarity scores.}

\item{\code{include_explanations}}{Include similarity explanations.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-print"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-print}{}}}
\subsection{Method \code{print()}}{
Print resource information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SearchResource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SearchResource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SearchResource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
