% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concepts.R
\name{ConceptsResource}
\alias{ConceptsResource}
\title{Concepts Resource}
\value{
A list containing the concept data.

A list containing the concept data with optional relationships and synonyms.

A list with \code{concepts} and any \code{failures}.

A list with suggestions and pagination metadata.

Related concepts with relationship scores.

Relationships data.

Recommendations grouped by source concept ID with pagination metadata.
}
\description{
R6 class providing access to concept operations.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ConceptsResource-new}{\code{ConceptsResource$new()}}
\item \href{#method-ConceptsResource-get}{\code{ConceptsResource$get()}}
\item \href{#method-ConceptsResource-get_by_code}{\code{ConceptsResource$get_by_code()}}
\item \href{#method-ConceptsResource-batch}{\code{ConceptsResource$batch()}}
\item \href{#method-ConceptsResource-suggest}{\code{ConceptsResource$suggest()}}
\item \href{#method-ConceptsResource-related}{\code{ConceptsResource$related()}}
\item \href{#method-ConceptsResource-relationships}{\code{ConceptsResource$relationships()}}
\item \href{#method-ConceptsResource-recommended}{\code{ConceptsResource$recommended()}}
\item \href{#method-ConceptsResource-print}{\code{ConceptsResource$print()}}
\item \href{#method-ConceptsResource-clone}{\code{ConceptsResource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-new"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-new}{}}}
\subsection{Method \code{new()}}{
Create a new ConceptsResource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$new(base_req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_req}}{Base httr2 request object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-get"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-get}{}}}
\subsection{Method \code{get()}}{
Get a concept by ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$get(
  concept_id,
  include_relationships = FALSE,
  include_synonyms = FALSE,
  include_hierarchy = FALSE,
  vocab_release = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_id}}{The OMOP concept ID.}

\item{\code{include_relationships}}{Include related concepts (parents/children). Default \code{FALSE}.}

\item{\code{include_synonyms}}{Include concept synonyms. Default \code{FALSE}.}

\item{\code{include_hierarchy}}{Include hierarchy information. Default \code{FALSE}.}

\item{\code{vocab_release}}{Specific vocabulary release (e.g., "2025.2"). Default \code{NULL}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-get_by_code"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-get_by_code}{}}}
\subsection{Method \code{get_by_code()}}{
Get a concept by vocabulary and code.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$get_by_code(
  vocabulary_id,
  concept_code,
  include_relationships = FALSE,
  include_synonyms = FALSE,
  include_hierarchy = FALSE,
  vocab_release = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vocabulary_id}}{The vocabulary ID (e.g., "SNOMED", "ICD10CM").}

\item{\code{concept_code}}{The concept code within the vocabulary.}

\item{\code{include_relationships}}{Include related concepts (parents/children). Default \code{FALSE}.}

\item{\code{include_synonyms}}{Include concept synonyms. Default \code{FALSE}.}

\item{\code{include_hierarchy}}{Include hierarchy information. Default \code{FALSE}.}

\item{\code{vocab_release}}{Specific vocabulary release (e.g., "2025.2"). Default \code{NULL}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-batch"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-batch}{}}}
\subsection{Method \code{batch()}}{
Get multiple concepts by IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$batch(
  concept_ids,
  include_relationships = FALSE,
  include_synonyms = FALSE,
  include_mappings = FALSE,
  vocabulary_filter = NULL,
  standard_only = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_ids}}{Vector of concept IDs (max 100).}

\item{\code{include_relationships}}{Include related concepts. Default \code{FALSE}.}

\item{\code{include_synonyms}}{Include concept synonyms. Default \code{FALSE}.}

\item{\code{include_mappings}}{Include concept mappings. Default \code{FALSE}.}

\item{\code{vocabulary_filter}}{Filter results to specific vocabularies.}

\item{\code{standard_only}}{Only return standard concepts. Default \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-suggest"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-suggest}{}}}
\subsection{Method \code{suggest()}}{
Get concept suggestions (autocomplete).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$suggest(
  query,
  page = 1,
  page_size = 10,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  vocab_release = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Search query (min 2 characters, max 100 characters).}

\item{\code{page}}{Page number (default 1).}

\item{\code{page_size}}{Number of suggestions per page (default 10, max 100).}

\item{\code{vocabulary_ids}}{Filter to specific vocabularies (character vector).}

\item{\code{domain_ids}}{Filter to specific domains (character vector).}

\item{\code{vocab_release}}{Specific vocabulary release (e.g., "2025.2").}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-related"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-related}{}}}
\subsection{Method \code{related()}}{
Get related concepts.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$related(
  concept_id,
  relationship_types = NULL,
  min_score = NULL,
  page_size = 20,
  vocab_release = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_id}}{The source concept ID.}

\item{\code{relationship_types}}{Filter by relationship types (e.g., c("Is a", "Maps to")).}

\item{\code{min_score}}{Minimum relationship score (0.0-1.0).}

\item{\code{page_size}}{Maximum number of results (default 20, max 100).}

\item{\code{vocab_release}}{Specific vocabulary release (e.g., "2025.1").}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-relationships"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-relationships}{}}}
\subsection{Method \code{relationships()}}{
Get concept relationships.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$relationships(
  concept_id,
  relationship_ids = NULL,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  include_invalid = FALSE,
  standard_only = FALSE,
  include_reverse = FALSE,
  vocab_release = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_id}}{The concept ID.}

\item{\code{relationship_ids}}{Filter by relationship type IDs (character vector or comma-separated string).}

\item{\code{vocabulary_ids}}{Filter by target vocabulary IDs (character vector or comma-separated string).}

\item{\code{domain_ids}}{Filter by target domain IDs (character vector or comma-separated string).}

\item{\code{include_invalid}}{Include relationships to invalid concepts. Default \code{FALSE}.}

\item{\code{standard_only}}{Only include relationships to standard concepts. Default \code{FALSE}.}

\item{\code{include_reverse}}{Include reverse relationships. Default \code{FALSE}.}

\item{\code{vocab_release}}{Specific vocabulary release version. Default \code{NULL}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-recommended"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-recommended}{}}}
\subsection{Method \code{recommended()}}{
Get recommended concepts using OHDSI Phoebe algorithm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$recommended(
  concept_ids,
  relationship_types = NULL,
  vocabulary_ids = NULL,
  domain_ids = NULL,
  standard_only = TRUE,
  include_invalid = FALSE,
  page = 1,
  page_size = 100
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_ids}}{Vector of source concept IDs (1-100).}

\item{\code{relationship_types}}{Filter by relationship types (max 20).}

\item{\code{vocabulary_ids}}{Filter to specific vocabularies (max 50).}

\item{\code{domain_ids}}{Filter to specific domains (max 50).}

\item{\code{standard_only}}{Only return standard concepts. Default \code{TRUE}.}

\item{\code{include_invalid}}{Include invalid/deprecated concepts. Default \code{FALSE}.}

\item{\code{page}}{Page number. Default 1.}

\item{\code{page_size}}{Results per page (default 100, max 1000).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-print"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-print}{}}}
\subsection{Method \code{print()}}{
Print resource information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ConceptsResource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ConceptsResource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ConceptsResource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
