% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-all-possible-regression.R
\name{ols_step_all_possible}
\alias{ols_step_all_possible}
\alias{ols_step_all_possible.default}
\alias{plot.ols_step_all_possible}
\title{All possible regression}
\usage{
ols_step_all_possible(model, ...)

\method{ols_step_all_possible}{default}(model, max_order = NULL, ...)

\method{plot}{ols_step_all_possible}(x, model = NA, print_plot = TRUE, ...)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{...}{Other arguments.}

\item{max_order}{Maximum subset order.}

\item{x}{An object of class \code{ols_step_all_possible}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
\code{ols_step_all_possible} returns an object of class \code{"ols_step_all_possible"}.
An object of class \code{"ols_step_all_possible"} is a data frame containing the
following components:

\item{mindex}{model index}
\item{n}{number of predictors}
\item{predictors}{predictors in the model}
\item{rsquare}{rsquare of the model}
\item{adjr}{adjusted rsquare of the model}
\item{rmse}{root mean squared error of the model}
\item{predrsq}{predicted rsquare of the model}
\item{cp}{mallow's Cp}
\item{aic}{akaike information criteria}
\item{sbic}{sawa bayesian information criteria}
\item{sbc}{schwarz bayes information criteria}
\item{msep}{estimated MSE of prediction, assuming multivariate normality}
\item{fpe}{final prediction error}
\item{apc}{amemiya prediction criteria}
\item{hsp}{hocking's Sp}
}
\description{
Fits all regressions involving one regressor, two regressors, three
regressors, and so on. It tests all possible subsets of the set of potential
independent variables.
}
\examples{
model <- lm(mpg ~ disp + hp, data = mtcars)
k <- ols_step_all_possible(model)
k

# plot
plot(k)

# maximum subset
model <- lm(mpg ~ disp + hp + drat + wt + qsec, data = mtcars)
ols_step_all_possible(model, max_order = 3)

}
\references{
Mendenhall William and  Sinsich Terry, 2012, A Second Course in Statistics Regression Analysis (7th edition).
Prentice Hall
}
