% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_vd.R
\name{fetch_vd}
\alias{fetch_vd}
\title{Fetch VecDyn dataset/s by ID}
\usage{
fetch_vd(ids, rate = 5, connections = 2, basereq = vb_basereq())
}
\arguments{
\item{ids}{a numeric ID or numeric vector of ids (preferably in an \code{ohvbd.ids} object) indicating the particular dataset/s to download.}

\item{rate}{maximum number of calls to the API per second.}

\item{connections}{number of simultaneous connections to the server at once. Maximum 8. \strong{Do not enable unless you really need to} as this hits the server significantly harder than usual.}

\item{basereq}{an \link[httr2:request]{httr2 request} object, as generated by \code{\link[=vb_basereq]{vb_basereq()}}. If \code{NA}, uses the default request.}
}
\value{
A list of \link[httr2:response]{httr2 response} objects, as an \code{ohvbd.responses} object.
}
\description{
Retrieve VecDyn dataset/s specified by their dataset ID.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
fetch_vd(54)

fetch_vd(c(423,424,425))

ohvbd.ids(c(423,424,425), "vd") |>
  fetch() # Calls fetch_vd()
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{vecdyn}
