% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_gbif.R
\name{fetch_gbif}
\alias{fetch_gbif}
\title{Fetch GBIF dataset/s by ID}
\usage{
fetch_gbif(ids, filepath = ".")
}
\arguments{
\item{ids}{a string or character vector of ids (preferably in an \code{ohvbd.ids} object) indicating the particular dataset/s to download.}

\item{filepath}{directory to save gbif download files into.}
}
\value{
A list of \link[rgbif:occ_download_get]{rgbif occ_download_get} objects, as an \code{ohvbd.responses} object.
}
\description{
Retrieve GBIF dataset/s specified by their dataset ID.
}
\note{
Only 300 datasets can be requested at once (for now) due to technical limitations originating from the GBIF server setup.
It is worth splitting longer lists of ids into a couple of chunks if you need more than this.

If you regularly use ohvbd to download large numbers of datasets at once and chunking is causing you other issues, please raise an issue at https://github.com/fwimp/ohvbd/issues.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
fetch_gbif("dbc4a3ae-680f-44e6-ab25-c70e27b38dbc")

ohvbd.ids("dbc4a3ae-680f-44e6-ab25-c70e27b38dbc", "gbif") |>
  fetch() # Calls fetch_gbif()
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{gbif}
