% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_body.R
\name{function_body}
\alias{function_body}
\title{Extract function body}
\usage{
function_body(fun, braces = FALSE, nchar = getOption("width") - 4)
}
\arguments{
\item{fun}{[\code{function}]\cr
A \code{function}.}

\item{braces}{[\code{logical(1)}]\cr
Remove \code{"{"} and \code{"}"} at start and end (if any)?}

\item{nchar}{[\code{integer(1)}]\cr
The maximum number of characters before abbreviation, at least \code{3}.}
}
\value{
A \code{character}, the body of \code{f}.
}
\description{
This function extracts the body of a function as a single \code{character}.
}
\examples{
fun <- mean.default
function_body(fun)
function_body(fun, braces = TRUE)
function_body(fun, nchar = 30)
}
\seealso{
Other function helpers: 
\code{\link{do.call_timed}()},
\code{\link{function_arguments}()},
\code{\link{function_defaults}()},
\code{\link{quiet}()},
\code{\link{timed}()},
\code{\link{try_silent}()},
\code{\link{variable_name}()}
}
\concept{function helpers}
\keyword{functional}
