# FACET RESULTS
#' @include AllGenerics.R
NULL

#' @rdname hal_facet
#' @export
hal_facet.HALQuery <- function(query, field = NULL, limit = 5, sort = c("count", "index"),
                               prefix = NULL, contains = NULL, pivot = NULL,
                               range = NULL, ignore_case = FALSE, ...) {
  ## Validation
  sort <- match.arg(sort, several.ok = FALSE)

  ## Prevent grouping and faceting
  if (!is.null(query$group)) query$group <- "false"

  query$facet <- "true"
  query$facet.field <- field
  query$facet.limit <- limit
  query$facet.sort <- sort
  query$facet.prefix <- prefix
  if (!is.null(contains)) {
    query$facet.contains <- contains
    query$facet.contains.ignoreCase <- ifelse(ignore_case, "true", "false")
  }
  if (!is.null(pivot)) {
    query$facet.pivot <- paste0(pivot, collapse = ",")
  }
  if (is.list(range) && length(range) > 0) {
    query$facet.range <- range$field
    query$facet.range.start <- range$start
    query$facet.range.end <- range$end
    query$facet.range.gap <- range$gap
  }
  query
}
