% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oceColorsTwo}
\alias{oceColorsTwo}
\alias{oce.colorsTwo}
\title{Create Two-Color Palette}
\usage{
oceColorsTwo(n, low = 2/3, high = 0, smax = 1, alpha = 1)
}
\arguments{
\item{n}{number of colors to generate.}

\item{low, high}{numerical values (in range 0 to 1) specifying the hue
for the low and high ends of the color scale.}

\item{smax}{numerical value (in range 0 to 1) for the color saturation.}

\item{alpha}{numerical value (in ragne 0 to 1) for the alpha (transparency)
of the colors.}
}
\description{
Create colors ranging between two specified limits, with white
in the middle.
}
\examples{
library(oce)
imagep(volcano - mean(range(volcano)),
    col = oceColorsTwo(128),
    zlim = "symmetric", zlab = "oceColorsTwo"
)
}
\seealso{
Other things related to colors: 
\code{\link{colormap}()},
\code{\link{colormapGMT}()},
\code{\link{oceColors9B}()},
\code{\link{oceColorsCDOM}()},
\code{\link{oceColorsChlorophyll}()},
\code{\link{oceColorsClosure}()},
\code{\link{oceColorsDensity}()},
\code{\link{oceColorsFreesurface}()},
\code{\link{oceColorsGebco}()},
\code{\link{oceColorsJet}()},
\code{\link{oceColorsOxygen}()},
\code{\link{oceColorsPAR}()},
\code{\link{oceColorsPalette}()},
\code{\link{oceColorsPhase}()},
\code{\link{oceColorsSalinity}()},
\code{\link{oceColorsTemperature}()},
\code{\link{oceColorsTurbidity}()},
\code{\link{oceColorsTurbo}()},
\code{\link{oceColorsVelocity}()},
\code{\link{oceColorsViridis}()},
\code{\link{oceColorsVorticity}()},
\code{\link{ocecolors}}
}
\concept{things related to colors}
