% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.R
\name{handleFlags,adp-method}
\alias{handleFlags,adp-method}
\title{Handle Flags in adp Objects}
\usage{
\S4method{handleFlags}{adp}(
  object = "oce",
  flags = NULL,
  actions = NULL,
  where = NULL,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{object}{an \linkS4class{adp} object.}

\item{flags}{A \link{list} specifying flag values upon which
actions will be taken. This can take two forms.
\itemize{
\item In the first form, the
list has named elements each containing a vector of integers. For example,
salinities flagged with values of 1 or 3:9 would be specified
by \code{flags=list(salinity=c(1,3:9))}. Several data items can be specified,
e.g. \code{flags=list(salinity=c(1,3:9), temperature=c(1,3:9))} indicates
that the actions are to take place for both salinity and temperature.
\item In the second form, \code{flags} is a list holding a single \emph{unnamed} vector, and
this means to apply the actions to \emph{all} the data entries.  For example,
\code{flags=list(c(1,3:9))} means to apply not just to salinity and temperature,
but to everything within the \code{data} slot.
}

If \code{flags} is not provided, then \code{\link[=defaultFlags]{defaultFlags()}} is called, to try to
determine a reasonable default.}

\item{actions}{an optional \link{list} that contains items with
names that match those in the \code{flags} argument.  If \code{actions}
is not supplied, the default will be to set all values identified by
\code{flags} to \code{NA}; this can also be specified by
specifying \code{actions=list("NA")}. It is also possible to specify
functions that calculate replacement values. These are provided
with \code{object} as the single argument, and must return a
replacement for the data item in question.
See \dQuote{Details} for the default that is used if \code{actions} is not supplied.}

\item{where}{an optional character value that permits the function to work with
objects that store flags in e.g. \code{object@metadata$flags$where}
instead of in \code{object@metadata$flags}, and data within
\code{object@data$where} instead of within \code{object@data}. The
default value of \code{NULL} means to look withing \code{object@metadata}
itself, and this is the default within \code{oce}.  (The purpose of \code{where}
is to make \code{oce} extensible by other packages, which may choose to store
data two levels deep in the \code{data} slot.)}

\item{debug}{An optional integer specifying the degree of debugging, with
value 0 meaning to skip debugging and 1 or higher meaning to print some
information about the arguments and the data. It is usually a good idea to set
this to 1 for initial work with a dataset, to see which flags are being
handled for each data item. If not supplied, this defaults to the value of
\code{\link{getOption}}\code{("oceDebug")}.}
}
\description{
Data-quality flags are stored in the \code{metadata}
slot of \linkS4class{oce} objects in a
\link{list} named \code{flags}.
The present function (a generic that has specialized versions
for various data classes) provides a way to
manipulate the contents of the \code{data} slot, based on
such data-quality flags. For example, a common operation is to replace
erroneous data with \code{NA}.

If the \code{flags} within \code{object}'s \code{metadata} slot is empty,
then \code{object} is returned, unaltered.
Otherwise, \code{handleFlags} examines \code{object@metadata$flags}
in the context of the \code{flags} argument, and then
carries out actions that are specified by the \code{actions} argument.
By default, this sets the returned \code{data} entries to \code{NA},
wherever the corresponding \code{metadata$flag} values
signal unreliable data. To maintain a hint as to why
\code{data} were changed, \code{metadata$flags} in the
returned value is a direct copy of the corresponding
entry in \code{object}.
}
\details{
If \code{flags} and \code{actions} are not provided, the
default is to consider a flag value of 1 to indicate bad data,
and 0 to indicate good data. Note that it only makes sense to use
velocity (\code{v}) flags, because other flags are, at least
for some instruments, stored as \code{raw} quantities, and such
quantities may not be set to \code{NA}.
}
\examples{
# Flag low "goodness" or high "error beam" values.
library(oce)
data(adp)
# Same as Example 2 of ?'setFlags,adp-method'
v <- adp[["v"]]
i2 <- array(FALSE, dim = dim(v))
g <- adp[["g", "numeric"]]
# Set thresholds on percent "goodness" and error "velocity".
G <- 25
V4 <- 0.45
for (k in 1:3) {
    i2[, , k] <- ((g[, , k] + g[, , 4]) < G) | (v[, , 4] > V4)
}
adpQC <- initializeFlags(adp, "v", 2)
adpQC <- setFlags(adpQC, "v", i2, 3)
adpClean <- handleFlags(adpQC, flags = list(3), actions = list("NA"))
# Demonstrate (subtle) change graphically.
par(mfcol = c(2, 1))
plot(adp, which = "u1", drawTimeRange = FALSE)
plot(adpClean, which = "u1", drawTimeRange = FALSE)
t0 <- 1214510000 # from locator()
arrows(t0, 20, t0, 35, length = 0.1, lwd = 3, col = "magenta")
mtext("Slight change above arrow", col = "magenta", font = 2)

}
\seealso{
Other functions relating to data-quality flags: 
\code{\link{defaultFlags}()},
\code{\link{handleFlags}()},
\code{\link{handleFlags,argo-method}},
\code{\link{handleFlags,ctd-method}},
\code{\link{handleFlags,oce-method}},
\code{\link{handleFlags,section-method}},
\code{\link{initializeFlagScheme}()},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{initializeFlagScheme,oce-method}},
\code{\link{initializeFlagScheme,section-method}},
\code{\link{initializeFlagSchemeInternal}()},
\code{\link{initializeFlags}()},
\code{\link{initializeFlags,adp-method}},
\code{\link{initializeFlags,oce-method}},
\code{\link{initializeFlagsInternal}()},
\code{\link{setFlags}()},
\code{\link{setFlags,adp-method}},
\code{\link{setFlags,ctd-method}},
\code{\link{setFlags,oce-method}}

Other things related to adp data: 
\code{\link{[[,adp-method}},
\code{\link{[[<-,adp-method}},
\code{\link{ad2cpCodeToName}()},
\code{\link{ad2cpHeaderValue}()},
\code{\link{adp}},
\code{\link{adp-class}},
\code{\link{adpAd2cpFileTrim}()},
\code{\link{adpConvertRawToNumeric}()},
\code{\link{adpEnsembleAverage}()},
\code{\link{adpFlagPastBoundary}()},
\code{\link{adpRdiFileTrim}()},
\code{\link{adp_rdi.000}},
\code{\link{applyMagneticDeclination,adp-method}},
\code{\link{as.adp}()},
\code{\link{beamName}()},
\code{\link{beamToXyz}()},
\code{\link{beamToXyzAdp}()},
\code{\link{beamToXyzAdpAD2CP}()},
\code{\link{beamToXyzAdv}()},
\code{\link{beamUnspreadAdp}()},
\code{\link{binmapAdp}()},
\code{\link{enuToOther}()},
\code{\link{enuToOtherAdp}()},
\code{\link{is.ad2cp}()},
\code{\link{plot,adp-method}},
\code{\link{read.adp}()},
\code{\link{read.adp.ad2cp}()},
\code{\link{read.adp.nortek}()},
\code{\link{read.adp.rdi}()},
\code{\link{read.adp.sontek}()},
\code{\link{read.adp.sontek.serial}()},
\code{\link{read.aquadopp}()},
\code{\link{read.aquadoppHR}()},
\code{\link{read.aquadoppProfiler}()},
\code{\link{rotateAboutZ}()},
\code{\link{setFlags,adp-method}},
\code{\link{subset,adp-method}},
\code{\link{subtractBottomVelocity}()},
\code{\link{summary,adp-method}},
\code{\link{toEnu}()},
\code{\link{toEnuAdp}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnu}()},
\code{\link{xyzToEnuAdp}()},
\code{\link{xyzToEnuAdpAD2CP}()}
}
\concept{functions relating to data-quality flags}
\concept{things related to adp data}
