% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\name{concatenate,oce-method}
\alias{concatenate,oce-method}
\title{Concatenate oce Objects (oce-Specific)}
\usage{
\S4method{concatenate}{oce}(object, ..., debug = getOption("oceDebug"))
}
\arguments{
\item{object}{An object of \linkS4class{oce}, or a list containing such
objects (in which case the remaining arguments are ignored).}

\item{...}{optional additional objects of \linkS4class{oce}.}

\item{debug}{integer indicating debugging level. If this exceeds 1,
some information may be printed during the processing.}
}
\value{
An object of \linkS4class{oce}.
}
\description{
This function concatenates oce objects. It is intended
for objects holding data sampled through time, and it works by pasting
together data linearly if they are vectors, by row if they are matrices,
and by second index if they are arrays. It has been tested for the following
classes:
\linkS4class{adp},
\linkS4class{adv},
\linkS4class{ctd},
and
\linkS4class{met}. It may do useful things for other classes, and
so users are encouraged to try, and to report problems to the developers.
It is unlikely that the function will do anything even remotely useful
for image and topographic data, to name just two cases that do not fit
the sampled-over-time category.
}
\examples{
## 1. Split, then recombine, a ctd object.
data(ctd)
ctd1 <- subset(ctd, scan <= median(ctd[["scan"]]))
ctd2 <- subset(ctd, scan > median(ctd[["scan"]]))
CTD <- concatenate(ctd1, ctd2)

## 2. Split, then recombine, an adp object.
data(adp)
midtime <- median(adp[["time"]])
adp1 <- subset(adp, time <= midtime)
adp2 <- subset(adp, time > midtime)
ADP <- concatenate(adp1, adp2)

\dontrun{
## 3. Download two met files and combine them.
met1 <- read.met(download.met(id=6358, year=2003, month=8))
met2 <- read.met(download.met(id=6358, year=2003, month=9))
MET <- concatenate(met1, met2)
}

}
\seealso{
Other functions that concatenate oce objects: 
\code{\link{concatenate}()},
\code{\link{concatenate,adp-method}},
\code{\link{concatenate,list-method}}
}
\author{
Dan Kelley
}
\concept{functions that concatenate oce objects}
