% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adv.R
\name{applyMagneticDeclination,adv-method}
\alias{applyMagneticDeclination,adv-method}
\title{Alter an adv Object to Account for Magnetic Declination}
\usage{
\S4method{applyMagneticDeclination}{adv}(
  object = "oce",
  declination = 0,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{object}{an \linkS4class{adv} object.}

\item{declination}{numeric value holding magnetic declination in degrees,
positive for clockwise from north.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
A \linkS4class{adv} object, adjusted as outlined in \dQuote{Details}.
}
\description{
Acoustic-Doppler velocimetry instruments that infer direction using magnetic
compasses need to have a correction applied for magnetic declination, if the
goal is to infer currents with x and y oriented eastward and northward,
respectively.  This is what the present function does (see \dQuote{Details}).
}
\details{
The returned value is a copy of \code{object} that has been modified in 4 ways.
(1) the horizontal components of velocity are rotated clockwise by
\code{declination} degrees.  (2) If the object holds heading values, then
\code{declination} is added to them. (3) The \code{north} item in the \code{metadata} slot
is set to \code{"geographic"}, and a warning is issued if this was also the value
in \code{object}.  (4) The \code{declination} item in the \code{metadata} slot is set to
the value supplied to this function.
}
\seealso{
Use \code{\link[=magneticField]{magneticField()}} to determine the declination,
inclination and intensity at a given spot on the world, at a given time.

Other things related to magnetism: 
\code{\link{applyMagneticDeclination}()},
\code{\link{applyMagneticDeclination,adp-method}},
\code{\link{applyMagneticDeclination,cm-method}},
\code{\link{applyMagneticDeclination,oce-method}},
\code{\link{magneticField}()}

Other things related to adv data: 
\code{\link{[[,adv-method}},
\code{\link{[[<-,adv-method}},
\code{\link{adv}},
\code{\link{adv-class}},
\code{\link{advSontekAdrFileTrim}()},
\code{\link{beamName}()},
\code{\link{beamToXyz}()},
\code{\link{enuToOther}()},
\code{\link{enuToOtherAdv}()},
\code{\link{plot,adv-method}},
\code{\link{read.adv}()},
\code{\link{read.adv.nortek}()},
\code{\link{read.adv.sontek.adr}()},
\code{\link{read.adv.sontek.serial}()},
\code{\link{read.adv.sontek.text}()},
\code{\link{rotateAboutZ}()},
\code{\link{subset,adv-method}},
\code{\link{summary,adv-method}},
\code{\link{toEnu}()},
\code{\link{toEnuAdv}()},
\code{\link{velocityStatistics}()},
\code{\link{xyzToEnu}()},
\code{\link{xyzToEnuAdv}()}
}
\author{
Dan Kelley, aided by Clark Richards and Jaimie Harbin.
}
\concept{things related to adv data}
\concept{things related to magnetism}
