% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amsr.R
\docType{data}
\name{amsr}
\alias{amsr}
\title{Sample amsr Data (Near Nova Scotia)}
\usage{
data(amsr)
}
\description{
This is a three-day composite satellite image for
July 27, 2023, trimmed to show waters south and east of
Nova Scotia, using code provide in the \dQuote{Details}
section.
}
\details{
The following code was used to create this dataset.
\preformatted{
library(oce)
amsr <- read.amsr(download.amsr(2023, 7, 27, destdir="~/data/amsr"))
amsr <- subset(amsr, -71 < longitude & longitude < -60, debug=2)
amsr <- subset(amsr,  36 < latitude  &  latitude <  45, debug=2)
}
}
\examples{
library(oce)
data(coastlineWorld)
data(amsr)
plot(amsr, "SST")
lines(coastlineWorld[["longitude"]], coastlineWorld[["latitude"]])

}
\seealso{
Other satellite datasets provided with oce: 
\code{\link{landsat}}

Other datasets provided with oce: 
\code{\link{adp}},
\code{\link{adv}},
\code{\link{argo}},
\code{\link{cm}},
\code{\link{coastlineWorld}},
\code{\link{ctd}},
\code{\link{ctdRaw}},
\code{\link{echosounder}},
\code{\link{landsat}},
\code{\link{lisst}},
\code{\link{lobo}},
\code{\link{met}},
\code{\link{ocecolors}},
\code{\link{rsk}},
\code{\link{sealevel}},
\code{\link{sealevelTuktoyaktuk}},
\code{\link{section}},
\code{\link{topoWorld}},
\code{\link{wind}},
\code{\link{xbt}}

Other things related to amsr data: 
\code{\link{[[,amsr-method}},
\code{\link{[[<-,amsr-method}},
\code{\link{amsr-class}},
\code{\link{composite,amsr-method}},
\code{\link{download.amsr}()},
\code{\link{plot,amsr-method}},
\code{\link{read.amsr}()},
\code{\link{subset,amsr-method}},
\code{\link{summary,amsr-method}}
}
\concept{datasets provided with oce}
\concept{satellite datasets provided with oce}
\concept{things related to amsr data}
