% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocd-package.R
\docType{package}
\name{ocd}
\alias{ocd}
\alias{ocd-package}
\title{ocd: A package for high-dimensional multiscale online changepoint detection}
\description{
The ocd package provides the S3 class \code{\link{ChangepointDetector}} that
processes data sequentially using the \code{\link{getData}} function and
aims to detect change as soon as it occurs online subject to false alarm
rates.
}
\examples{
set.seed(2020)
p <- 100
thresh <- setNames(c(11.62, 179.48, 54.87), c('diag', 'off_d', 'off_s'))
detector <- ChangepointDetector(dim=p, method='ocd', beta=1, thresh=thresh)
old_mean <- rnorm(p); new_mean <- old_mean + c(rnorm(p/4), rep(0,3*p/4)) / sqrt(p/4)

# using functional semantics native in R
detector <- setStatus(detector, 'estimating')
for (i in 1:10000){
  x_new <- rnorm(p, mean=old_mean)
  detector <- getData(detector, x_new)
}
print(detector)

detector <- setStatus(detector, 'monitoring')
for (i in 1:200){
  x_new <- rnorm(p, old_mean * (i < 100) + new_mean * (i>=100))
  detector <- getData(detector, x_new)
}
print(detector)

\dontrun{
# alternative way to write the above using the piping semantics
library(magrittr)
detector \%<>\% reset
detector \%<>\% setStatus('estimating')
for (i in 1:10000){
  x_new <- rnorm(p, mean=old_mean)
  detector \%<>\% getData(x_new)
}
detector \%>\% print

detector \%<>\% setStatus('monitoring')
for (i in 1:200){
  x_new <- rnorm(p, old_mean * (i < 100) + new_mean * (i>=100))
  detector \%<>\% getData(x_new)
}
detector \%>\% print
}
}
\references{
Chen, Y., Wang, T. and Samworth, R. J. (2020) High-dimensional
multiscale online changepoint detection \emph{Preprint}. arxiv:2003.03668.
}
\seealso{
\code{\link{ChangepointDetector}} for detailed usage.
}
