% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_slash_stab.R
\name{nyc_slash_stab}
\alias{nyc_slash_stab}
\title{Inmate Incidents - Slashing and Stabbing}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Public-Safety/Inmate-Incidents-Slashing-and-Stabbing/gakf-suji/about_data>
}
\usage{
nyc_slash_stab(limit = 10000, filters = list(), timeout_sec = 30)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing Inmate Incidents - Slashing and Stabbing data.
}
\description{
Downloads Inmate Incidents - Slashing and Stabbing data from NYC Open Data.
}
\details{
This dataset contains information about the kind of violent incident that happens among inmates
in prison. There is row that provide the incidents' ID, the data they were reported, the kind
of incident they were, and in what facilities those incidents occurred.A researcher might
want to use this dataset to investigate the kind of crimes inmates commit while they are
incarcerated.
}
\examples{
# Examples that hit the live NYC Open Data API are guarded so CRAN checks
# do not fail when the network is unavailable or slow.
if (interactive() && curl::has_internet()) {
  small_sample <- nyc_slash_stab(limit = 2)
  small_sample

 nyc_slash_stab(limit = 2, filters = list(incident_type = "Slashing"))
}
}
