% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_film_permits.R
\name{nyc_film_permits}
\alias{nyc_film_permits}
\title{Film Permits}
\source{
NYC Open Data: <https://data.cityofnewyork.us/City-Government/Film-Permits/tg4x-b46p/about_data>
}
\usage{
nyc_film_permits(limit = 10000, filters = list(), timeout_sec = 30)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing Film Permits data.
}
\description{
Downloads Film Permits data from NYC Open Data.
}
\details{
Permits are generally required when asserting the exclusive use of city property,
like a sidewalk, a street, or a park.
See http://www1.nyc.gov/site/mome/permits/when-permit-required.page
}
\examples{
# Examples that hit the live NYC Open Data API are guarded so CRAN checks
# do not fail when the network is unavailable or slow.
if (interactive() && curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_film_permits(limit = 2)
  small_sample

  nyc_film_permits(limit = 2, filters = list(eventtype = "Shooting Permit"))
}

}
