% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_any_dataset.R
\name{nyc_any_dataset}
\alias{nyc_any_dataset}
\title{Load Any NYC Open Data Dataset}
\usage{
nyc_any_dataset(json_link, limit = 10000, timeout_sec = 30)
}
\arguments{
\item{json_link}{A Socrata dataset JSON endpoint URL (e.g., "https://data.cityofnewyork.us/resource/abcd-1234.json").}

\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing the requested dataset.
}
\description{
Downloads any NYC Open Data dataset given its Socrata JSON endpoint.
}
\examples{
# Examples that hit the live NYC Open Data API are guarded so CRAN checks
# do not fail when the network is unavailable or slow.
if (interactive() && curl::has_internet()) {
  endpoint <- "https://data.cityofnewyork.us/resource/erm2-nwe9.json"
  out <- try(nyc_any_dataset(endpoint, limit = 3), silent = TRUE)
  if (!inherits(out, "try-error")) {
    head(out)
  }
}
}
