% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_cat.R
\name{trace_cat}
\alias{trace_cat}
\title{Trace diagnostics for categorical randomizations}
\usage{
trace_cat(
  x,
  fun = c("nullcat", "quantize"),
  n_iter = 1000L,
  thin = NULL,
  n_chains = 5L,
  n_cores = 1L,
  stat = NULL,
  seed = NULL,
  plot = FALSE,
  ...
)
}
\arguments{
\item{x}{Matrix of categorical data (integers) or quantitative values.}

\item{fun}{Which function to trace: \code{"nullcat"} or \code{"quantize"}.}

\item{n_iter}{Total number of update iterations to simulate. Default is 1000.}

\item{thin}{Thinning interval (updates per recorded point). Default ~ \code{n_iter/100}.
Smaller values increase resolution but increase run time.}

\item{n_chains}{Number of independent chains to run, to assess consistency (default \code{5}).}

\item{n_cores}{Parallel chains (default \code{1}).}

\item{stat}{Function that compares \code{x} to a permuted \code{x_rand} to quantify their
similarity. Either a function \code{f(x, x_rand)} returning a scalar, or \code{NULL}.
If \code{NULL} (the default), traces use Cohen's kappa for \code{nullcat()} or Pearson's
correlation for \code{quantize()}.}

\item{seed}{Optional integer seed for reproducible traces.}

\item{plot}{If TRUE, plot the traces.}

\item{...}{Arguments to the chosen \code{fun} (\code{nullcat()} or \code{quantize()}),
such as \code{method}, \code{n_strata}, \code{fixed}, etc.}
}
\value{
An object of class \code{"cat_trace"} with elements:
\itemize{
\item \code{traces}: matrix of size (n_steps+1) x n_chains, including iteration 0
\item \code{steps}: integer vector of iteration numbers (starting at 0)
\item \code{fun}, \code{n_iter}, \code{thin}, \code{n_chains}, \code{n_cores}, \code{stat_name}, \code{call}
\item \code{fun_args}: list of the \code{...} used (for reproducibility)
}
Plotting is available via \code{plot(cat_trace)}.
}
\description{
Applies \code{nullcat()} or \code{quantize()} to a community matrix, recording
a summary statistic at each iteration to help assess mixing on a given dataset.
}
\examples{
# nullcat trace
set.seed(123)
x <- matrix(sample(1:5, 2500, replace = TRUE), 50)
tr <- trace_cat(x, n_iter = 1000, n_chains = 5, fun = "nullcat",
                method = "curvecat")
plot(tr)

# quantize trace
x <- matrix(runif(2500), 50)
tr <- trace_cat(x, n_iter = 1000, n_chains = 5, fun = "quantize",
                method = "curvecat", n_strata = 3, fixed = "cell")
plot(tr)
}
