% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npi.R
\docType{package}
\name{npi-package}
\alias{npi}
\alias{npi-package}
\title{npi: Access the U.S. National Provider Identifier Registry API}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Access the United States National Provider Identifier Registry API \url{https://npiregistry.cms.hhs.gov/api/}. Obtain and transform administrative data linked to a specific individual or organizational healthcare provider, or perform advanced searches based on provider name, location, type of service, credentials, and other attributes exposed by the API.
}
\details{
\pkg{npi} makes it easy to search and work with data from the U.S.
National Provider Identifier (NPI) Registry API (v2.1) directly from R.
Obtain rich administrative data linked to a specific individual or
organizational healthcare provider, or perform advanced searches based on
provider name, location, type of service, credentials, and many other
attributes. npi provides convenience functions for data extraction so you can
spend less time wrangling data and more time putting data to work.

There are three functions you're likely to need from this package. The first
is \code{\link{npi_search}}, which allows you to query the NPI Registry and
returns up to 1,200 full NPI records as a data frame (tibble). Next, you can
use \code{\link{npi_summarize}} on these results to obtain a human-readable
summary of each record. Finally, \code{\link{npi_flatten}} extracts and
flattens conceptually-related subsets of data into a tibble that are joined
by the `npi` column into an analysis-ready object.
}
\section{Package options}{


  \pkg{npi}'s default user agent is the URL of the package's GitHub
  repository, \url{https://github.com/ropensci/npi}. You can customize
  it by setting the \code{npi_user_agent} option:

  \code{options(npi_user_agent = "your_user_agent_here")}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ropensci/npi/}
  \item \url{https://docs.ropensci.org/npi/}
  \item \url{https://npiregistry.cms.hhs.gov/api/}
  \item Report bugs at \url{https://github.com/ropensci/npi/issues/}
}

}
\author{
\strong{Maintainer}: Frank Farach \email{frank.farach@gmail.com} (\href{https://orcid.org/0000-0002-2145-0145}{ORCID}) [copyright holder]

Other contributors:
\itemize{
  \item Sam Parmar \email{parmartsam@gmail.com} [contributor]
  \item Matthias Grenié \email{matthias.grenie@idiv.de} (\href{https://orcid.org/0000-0002-4659-7522}{ORCID}) [reviewer]
  \item Emily C. Zabor \email{zabore2@ccf.org} (\href{https://orcid.org/0000-0002-1402-4498}{ORCID}) [reviewer]
}

}
\keyword{internal}
