% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simultane_Inferenz_Funktionen_nph_1-3.R
\name{plot.nphparams}
\alias{plot.nphparams}
\title{Plot nphparams Objects}
\usage{
\method{plot}{nphparams}(
  x,
  xlim = NULL,
  ylim = c(0, 1),
  trt_name = "Treatment",
  ctr_name = "Control",
  xlab = "Time",
  ylab = "Survival",
  main = "",
  col_ctr = 1,
  col_trt = 2,
  atrisktimes = 0:3,
  bold = 2,
  showlines = FALSE,
  show_rmst_diff = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{nphparams}.}

\item{xlim}{limits of the x-axis, must be a numeric vector of length two}

\item{ylim}{limits of the y-axis, must be a numeric vector of length two}

\item{trt_name}{character, an optional name for group 1 to be shown with the number at risk table in the plot. Default is "Treatment".}

\item{ctr_name}{character, an optional name for group 0 to be shown with the number at risk table in the plot. Default is "Control".}

\item{xlab}{character, an optional label for the x-axis. Default is "Time".}

\item{ylab}{character, an optional label for the x-axis. Default is "Survival".}

\item{main}{character, an optional title of the plot. Default is "", showing  no title.}

\item{col_ctr}{the color of the survival curve estimate of group 0. Default is 1 (black).}

\item{col_trt}{the color of the survival curve estimate of group 1. Default is 2 (red).}

\item{atrisktimes}{numeric vector of time-points for which the number at risk is displayed.}

\item{bold}{numeric, passed to linewidth and font settings. Default is 2, resulting in lines
of width 2 and boldfont. Use 1 for line-width 1 and standard font.}

\item{showlines}{logical, indicating whether the time-points or the quantile-probabilites defined
for the requested parametes should be shown in terms of vertical or horizontal lines. Default is \code{FALSE}.}

\item{show_rmst_diff}{logical, indicating whether the estiamted difference in restricted mean survival times should
by visualized by a gray background area.}

\item{...}{further arguments, not used}
}
\description{
Plots the estimated survival distributions, shows numbers at risk and indicates the requested parameters for quantifying differences between the survival curves.
}
\details{
When setting \code{show_lines}, line type 2 (dashed) is used for survival probabilities and quantiles, line type
3 (dotted) is used for the score test, average hazard ratio and Cox model hazard ratio and
line type 5 (long dashed) is used for restricted mean survival time.
}
\examples{
data(pembro)
set1<-nphparams(time=time, event=event, group=group,data=pembro,
param_type=c("score","S"),
param_par=c(3.5,2),
param_alternative=c("less","greater"),
closed_test=TRUE,alternative_test="one.sided")
print(set1)
plot(set1,trt_name="Pembrolizumab",ctr_name="Cetuximab")

set2<-nphparams(time=time, event=event, group=group, data=pembro,  
param_type=c("S","S","S","Q","RMST"),
param_par=c(0.5,1,2,0.5,3.5))
print(set2)
plot(set2,showlines=TRUE,show_rmst_diff=TRUE)

}
\seealso{
\code{\link{nphparams}}, \code{\link{plot.nphparams}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}
}
