% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nparsurv_test.R
\name{nparsurv_test}
\alias{nparsurv_test}
\title{Nonparametric Tests for Main Effects, Simple Effects and Interaction Effect in a Two-Factorial Design with Censored Data}
\usage{
nparsurv_test(data)
}
\arguments{
\item{data}{A \code{\link{data.frame}} of the form (time, status, factorA, factorB)
   \describe{
   \item{time:}{time of event or censoring, numeric}
    \item{status:}{indicator for censoring, 1=event, 0=censored, integer}
   \item{factorA:}{first factor variable, factor}
     \item{factorB:}{second factor variable, factor}
   }


Missing values must be saved as \code{NA}.}
}
\value{
A \code{nparsurv_test} object containing the following components:
\item{maineffectA / maineffectB}{The test statistic and p-value for the nullhypotheses 'no main effect of factor A' and 'no main effect of factor B' respectively.}
 \item{simpleeffectA / simpleeffectB}{The test statistic and p-value for the null hypotheses 'no simple effect of factor A' and 'no simple effect of factor B' respectively.}
 \item{interactioneffect}{The test statistic and p-value for the null hypothesis 'no interaction effect between factor A and factor B'.}
}
\description{
The \code{nparsurv_test} function calculates the test statistics and the p-values as described in 'Nonparametric Methods for Factorial Designs with Censored Data'
by Akritas and Brunner.
}
\details{
The package provides tests for a survival setting with two influencing variables, that are factors with at
 least two levels each. Details are shown in 'Nonparametric Methods for Factorial Designs with Censored Data' by Akritas
  and Brunner.
  The \code{nparsurv_test} function returns the values of the five test statistics: the tests for main effects, simple effects
  and the interaction effect. Additionally, based on the asymptotic chi-square distribution of the test statistic under the nullhypothesis, p-values are computed.
}
\examples{
data_ovarian<-data.frame(survival::ovarian$futime,
                       survival::ovarian$fustat,
                       as.factor(survival::ovarian$resid.ds),
                       as.factor(survival::ovarian$rx))
nparsurv_test(data_ovarian)

data_GBSG2<-data.frame(TH.data::GBSG2$time,
                       TH.data::GBSG2$cens,
                       TH.data::GBSG2$tgrade,
                       TH.data::GBSG2$horTh)
nparsurv_test(data_GBSG2)

}
\references{
Michael G. Akritas, Edgar Brunner(1997). Nonparametric Methods for Factorial Designs with Censored Data. Journal
           of the American Statistical Association.
}

