% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.nonstat.R
\name{is.nonstat}
\alias{is.nonstat}
\title{Test for nonstationarity}
\usage{
is.nonstat(tseries, nEp = 2, cut.psr1 = 1.1, cut.psr2 = 1.01, span = 3)
}
\arguments{
\item{tseries}{a numerical vector}

\item{nEp}{number of epochs (in which time series is cut for PSR calculation)}

\item{cut.psr1}{threshold for the trend diagnostic, Rhat(1), which assesses whether a process is trending}

\item{cut.psr2}{threshold for the changing variance diagnostic, Rhat(2), which assesses whether the processe's variance is changing over time}

\item{span}{numerical value that is passed to the \code{loess} function}
}
\value{
a logical scalar indicating whether the prcoess has been diagnosed as non-stationary (\code{TRUE}) or stationary (\code{FALSE})
}
\description{
Applies a nonvisual, diagnostic-based screening procedure to determine whether a univariate time series violates the assumption of stationarity. Specifically, the function evaluates (a) the presence of a trend and (b) changes in variance over time. These two dimensions of nonstationarity are assessed using two R-hat-type statistics adapted from Bayesian convergence diagnostics and Levene's test.
}
\examples{
set.seed( 8332278 )
x <- rnorm( 50 )
is.nonstat( x )
}
\references{
Zitzmann, S., Lindner, C., Lohmann, J. F., & Hecht, M. (2024). "A Novel Nonvisual Procedure for Screening for Nonstationarity in Time Series as Obtained from Intensive Longitudinal Designs" \href{https://www.researchgate.net/publication/384354932_A_Novel_Nonvisual_Procedure_for_Screening_for_Nonstationarity_in_Time_Series_as_Obtained_from_Intensive_Longitudinal_Designs}{Preprint}
}
