#' Categories4: Structured (triangular / normal-like) nominal distribution
#'
#' A dataset of dummy nominal data inspired by characters or species
#' from the Bikini Bottom universe (SpongeBob SquarePants).
#'
#' The dataset represents a structured nominal distribution in which
#' a limited number of categories dominate, followed by a gradual and
#' approximately symmetric decline in frequencies. This pattern is
#' consistent with a triangular or normal-like shape rather than a
#' strongly long-tailed (Pareto/exponential) distribution.
#'
#' The dataset was intentionally designed for pedagogical purposes to
#' illustrate dominance, symmetry, and modal structure in nominal data,
#' and to serve as a contrast with truly long-tailed distributions
#' included elsewhere in the package.
#'
#' @format A data frame with 250 rows and 1 variable:
#' \describe{
#'   \item{animal}{Character or species name (11 categories inspired by Bikini Bottom).}
#' }
#'
#' @examples
#' categories4
#'
#' # Centered dot plot showing a structured (normal-like) pattern
#' shape_comp_plot(categories4, "animal")
#'
#' # Pareto chart showing dominance without a strong long tail
#' pareto(categories4, "animal")
#'
#' # Ranked and centered bar plots
#' ranked_barplot(categories4, "animal")
#' centered_barplot(categories4, "animal")
"categories4"
