% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlsic.R
\name{equa2vecmat}
\alias{equa2vecmat}
\title{Parse linear equations/inequalities}
\usage{
equa2vecmat(nm_par, linear, sep = "=")
}
\arguments{
\item{nm_par}{a string vector of variable names. It will be used in the symbolic
derivation.}

\item{linear}{string vector of linear equations like \code{"a+2*c+3*b = 0"}}

\item{sep}{separator of two parts of equations. Use for example
">=" for linear inequalities}
}
\value{
an augmented matrix. Its first column is the rhs vector.
Other columns are named by nm_par. If the vector linear is NULL or its content
is empty a NULL is returned
}
\description{
parse a text vector of linear equations and produce a corresponding
matrix and right hand side vector
}
\examples{
equa2vecmat(c("a", "b", "c"), "a+2*c+3*b = 0", "=")
}
