\name{jordan}
\docType{data}
\alias{jordan}
\title{Data from Jordan subset of PISA 2006 data}
\description{
  The data stem from the large-scale assessment study PISA 2006
  (Organisation for Economic Co-Operation and Development, 2009) where
  competencies of 15-year-old students in reading, mathematics, and science
  are assessed using nationally representative samples in 3-year cycles. In
  this example, data from the student background questionnaire from the
  Jordan sample of PISA 2006 were used. Only data of students with complete
  responses to all 15 items (N = 6,038) were considered.
}
\usage{data(jordan)}
\format{
  A data frame of fifteen variables and 6,038 observations:
  \describe{
    \item{x1}{indicator for enjoyment of science, item ST16Q01: I generally
    have fun when I am learning <broad science> topics.}
    \item{x2}{indicator for enjoyment of science, item ST16Q02: I like reading
    about <broad science>.}
    \item{x3}{indicator for enjoyment of science, item ST16Q03: I am happy
    doing <broad science> problems.}
    \item{x4}{indicator for enjoyment of science, item ST16Q04: I enjoy
    acquiring new knowledge in <broad science>.}
    \item{x5}{indicator for enjoyment of science, item ST16Q05: I am
    interested in learning about <broad science>.}
    \item{x6}{indicator for academic self-concept in science, item ST37Q01: I
    can easily understand new ideas in <school science>.}
    \item{x7}{indicator for academic self-concept in science, item ST37Q02:
    Learning advanced <school science> topics would be easy for me.}
    \item{x8}{indicator for academic self-concept in science, item ST37Q03:
    I can usually give good answers to <test questions> on <school
    science> topics.}
    \item{x9}{indicator for academic self-concept in science, item ST37Q04:
    I learn <school science> topics quickly.}
    \item{x10}{indicator for academic self-concept in science, item ST37Q05:
    <School science> topics are easy for me.} 
    \item{x11}{indicator for academic self-concept in science, item ST37Q06:
    When I am being taught <school science>, I can understand the concepts very
    well.}
    \item{y1}{indicator for career aspirations in science, item ST29Q01: I
    would like to work in a career involving <broad science>.}
    \item{y2}{indicator for career aspirations in science, item ST29Q02: I
    would like to study <broad science> after <secondary school>.}
    \item{y3}{indicator for career aspirations in science, item ST29Q03: I
    would like to spend my life doing advanced <broad science>.}
    \item{y4}{indicator for career aspirations in science, item ST29Q04: I
    would like to work on <broad science> projects as an adult.}
  }
}
\source{
Organisation for Economic Co-Operation and Development (2009). \emph{Pisa 2006:
Science competencies for tomorrow's world} (Tech. Rep.). Paris, France.
Obtained from: \url{https://www.oecd.org/pisa/pisaproducts/database-pisa2006.htm}
}
\examples{
data(jordan)
}
\keyword{datasets}

