% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaceConfig.R
\name{spaceConfig}
\alias{spaceConfig}
\title{Get search space configuration}
\usage{
spaceConfig(search.space = c("ivbase", "oralbase"))
}
\arguments{
\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}
}
\value{
A list with four elements:
\itemize{
\item route: Administration route ("bolus", "oral", or NULL).
\item params: Character vector of parameter names expected in the string vector.
\item param_dependencies: Named list of functions that compute dependent parameters.
\item fixed_params: Named list of fixed parameter values.
}
}
\description{
Retrieve the configuration for a specified search space.
}
\details{
Pre-defined search spaces:
\itemize{
\item "ivbase": IV bolus model, 11 parameters, supports 1 to 3 compartments.
\item "oralbase": Oral model, 12 parameters (adds eta.ka), supports 1 to 3 compartments.
}

For "ivbase" and "oralbase", param_dependencies handle the relationship between
Michaelis-Menten elimination (mm) and the associated variability parameters
(eta.vmax, eta.cl).
}
\examples{
# Get IV base configuration
config <- spaceConfig("ivbase")
config$params

# Get oral base configuration
config <- spaceConfig("oralbase")
config$params

}
\seealso{
\link{mod.run} for the main function that uses these configurations.
\link{parseParams} for parameter parsing using configurations.
}
\author{
Zhonghui Huang
}
