% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseParams.R
\name{parseParams}
\alias{parseParams}
\title{Parse string vector to model parameters}
\usage{
parseParams(string, config)
}
\arguments{
\item{string}{Numeric vector containing parameter values in the order
specified by the search space configuration}

\item{config}{List object returned by \code{spaceConfig()},
containing parameter definitions and dependencies}
}
\value{
A named list containing:
\itemize{
\item All parameters specified in config$params with their values
\item Computed dependent parameters based on param_dependencies
\item Fixed parameters from \code{fixed_params}
\item Administration route from config$route
}
}
\description{
Converts a numeric vector of parameter values into a named list of model
parameters based on the search space configuration.
}
\details{
This function performs three main operations:
\enumerate{
\item Maps the input vector to named parameters
\item Computes dependent parameter values using defined functions
\item Adds fixed parameters and route information
}
}
\examples{
# Example 1: Parse IV base model parameters
config_iv <- spaceConfig("ivbase")
parseParams(c(2, 1, 1, 0, 0, 1, 1, 0, 1, 1), config_iv)

# Example 2: Parse oral base model parameters
config_oral <- spaceConfig("oralbase")
parseParams(c(2, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1), config_oral)

# Example 3: Parse custom configuration parameters
custom_config <- list(route = "oral", params = c("no.cmpt", "eta.cl", "eta.vc"),
                      param_dependencies = list(), fixed_params = list(mm = 0))
parseParams(c(1, 1, 1), custom_config)

}
\seealso{
\code{spaceConfig()}, \code{mod.run()}
}
\author{
Zhonghui Huang
}
