% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga.operator.R
\name{gaControl}
\alias{gaControl}
\title{Control parameters for genetic algorithm}
\usage{
gaControl(
  npop = 20,
  niter = 20,
  pcross = 0.7,
  pmut = 0.1,
  diff_tol = 1,
  nls = 3
)
}
\arguments{
\item{npop}{Integer. The number of individuals (chromosomes) in the
population for each generation.}

\item{niter}{Integer. The maximum number of generations to run the GA.}

\item{pcross}{Numeric in \eqn{[0, 1]}. Probability of performing
crossover between two selected parents.}

\item{pmut}{Numeric in \eqn{[0, 1]}. Probability of mutating each
bit in a chromosome.}

\item{diff_tol}{A numeric value specifying the significance difference threshold.
Values within this threshold are considered equal and receive the same rank.
Default is 1.}

\item{nls}{Integer. Frequency (in generations) of running local
exhaustive search around the best current model.}
}
\value{
A named list containing all GA control parameters.
}
\description{
Creates a list of control settings for the \code{ga.operator()} function.
}
\examples{
# Default settings
gaControl()

}
\seealso{
\code{\link{ga.operator}}, \code{\link{rank_new}}, \code{\link{runlocal}}
}
\author{
Zhonghui Huang
}
