% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseCode.R
\name{decodeBinary}
\alias{decodeBinary}
\title{Decode binary encoding to categorical encoding}
\usage{
decodeBinary(binary_string, search.space = "ivbase", custom_config)
}
\arguments{
\item{binary_string}{Numeric vector of bits (0/1). Length must match the
expected layout for the selected search.space.}

\item{search.space}{Character string specifying which search space to use.
Options are "ivbase", "oralbase", or "custom". Default is "ivbase".}

\item{custom_config}{Optional named list defining a custom parameter structure.
If provided, the parameter names are taken from the names of this list.
If NULL, a default parameter structure is used based on the selected
search space.}
}
\value{
Numeric vector of categorical parameter values.
}
\description{
Converts a binary-encoded GA chromosome (0/1 vector) into a categorical
parameter vector.
}
\details{
Supported search spaces:
\itemize{
\item "ivbase": binary string has 12 bits and decodes to 10 values.
\item "oralbase": binary string has 13 bits and decodes to 11 values.
\item "custom": binary string has 29 bits and decodes to 24 values.
}

Legacy layout ("ivbase" and "oralbase"):
\itemize{
\item The first two bits encode the number of compartments (no.cmpt) as
00 or 01 for 1, 10 for 2, and 11 for 3.
\item The middle parameters are copied directly and preserve values such as
0, 1, and -1.
\item The last two bits encode the residual error model (rv) as 00 or 01
for 1, 10 for 2, and 11 for 3.
}

Custom layout ("custom"):
\itemize{
\item Multi-level parameters are stored as 2-bit fields (for example,
no.cmpt, absorption type, absorption delay, residual error model, and
allometric scaling).
\item Binary flags are stored as single bits, including absolute
bioavailability (abs.bio), the Michaelis-Menten indicator (mm), and the
correlation indicator (mcorr).
\item Inter-individual variability indicators (eta.*) are stored as 16
single-bit flags in a fixed order.
}

For "custom", the categorical output order is:
\preformatted{
no.cmpt, abs.type, abs.delay, abs.bio,
eta.vmax, eta.km, eta.cl, eta.vc, eta.vp, eta.vp2, eta.q, eta.q2,
eta.ka, eta.tlag, eta.D2, eta.F1, eta.Fr, eta.mtt, eta.n, eta.bio,
mm, mcorr, rv, allometric_scaling
}
}
\examples{
binary_iv <- c(0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1)
decodeBinary(binary_iv, "ivbase")

binary_oral <- c(0, 1, rep(0, 9), 1, 1)
decodeBinary(binary_oral, "oralbase")

binary_custom <- c(
  0, 0, 0, 1, 1, 1, 1, rep(0, 16), 0, 1, 1, 0, 0, 1
)
decodeBinary(binary_custom, "custom")

}
\seealso{
\code{\link{.twoBitCode}}, \code{\link{encodeBinary}}
}
\author{
Zhonghui Huang
}
