% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aco.operator.R
\name{aco.operator}
\alias{aco.operator}
\title{ACO operator for model selection}
\usage{
aco.operator(
  dat,
  param_table = NULL,
  search.space = c("ivbase", "oralbase"),
  no.cores = NULL,
  aco.control = acoControl(),
  penalty.control = penaltyControl(),
  precomputed_results_file = NULL,
  foldername = NULL,
  filename = "test",
  seed = 1234,
  .modEnv = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dat}{A data frame containing pharmacokinetic data in standard
nlmixr2 format, including "ID", "TIME", "EVID", and "DV", and may include
additional columns.}

\item{param_table}{Optional data frame of initial parameter estimates. If NULL,
the table is generated by \code{auto_param_table()}.}

\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}

\item{no.cores}{Integer. Number of CPU cores to use. If NULL, uses
\code{rxode2::getRxThreads()}.}

\item{aco.control}{A list of ACO control parameters defined by
\code{acoControl()}. Includes:
\itemize{
\item nants - number of ants per iteration.
\item niter - maximum number of iterations.
\item rho - pheromone evaporation rate.
\item phi0 - initial pheromone level.
\item phi_min, phi_max - bounds for pheromone levels.
\item alpha - pheromone weight exponent.
\item elite - proportion of best solutions preserved each iteration.
\item prob.min - minimum sampling probability.
\item diff_tol - threshold for significant fitness difference.
}}

\item{penalty.control}{A list of penalty control parameters defined by
\code{penaltyControl()}, specifying penalty values used for model diagnostics
during fitness evaluation.}

\item{precomputed_results_file}{Optional path to a CSV file of previously computed
model results used for caching.}

\item{foldername}{Character string specifying the folder name for storing
intermediate results. If \code{NULL} (default), \code{tempdir()}
is used for temporary storage. If specified, a cache directory
is created in the current working directory.}

\item{filename}{Optional character string used as a prefix for output files.
Defaults to "test".}

\item{seed}{Integer. Random seed controlling the random sampling steps of the
ant colony optimization operator for reproducible runs. Default is 1234.}

\item{.modEnv}{Optional environment used internally to store model indices,
cached parameter tables, and results across steps.}

\item{verbose}{Logical. If TRUE, print progress messages.}

\item{...}{Additional arguments passed to \code{mod.run()}.}
}
\value{
An object of class \code{"acoOperatorResult"}, containing:
\itemize{
\item \code{$`Final Selected Code`} - Vector representation of the best model.
\item \code{$`Final Selected Model Name`} - Human-readable name of the selected model.
\item \code{$`Model Run History`} - Data frame of model runs across iterations.
\item \code{$`Node Run History`} - History of pheromone probabilities for each iteration.
}
}
\description{
Implements an ant colony optimization algorithm to explore
model space and identify the best-performing model given pre-defined fitness
function.
}
\details{
The ACO approach uses a colony of "ants" to stochastically sample models,
evaluate their fitness, and update pheromone trails that guide future searches.
This iterative process balances exploration of new models with exploitation
of promising candidates.
}
\examples{
\donttest{
# Example usage with phenotype dataset
outs <- aco.operator(
  dat = pheno_sd,
  param_table = NULL,
  search.space = "ivbase",
  aco.control = acoControl(),
  saem.control = nlmixr2est::saemControl(
    seed = 1234,
    nBurn = 200,
    nEm   = 300,
    logLik = TRUE
  )
)
print(outs)
}

}
\seealso{
\code{\link{acoControl}},
\code{\link{penaltyControl}},
\code{\link{auto_param_table}},
\code{\link{mod.run}},
\code{\link{ppkmodGen}}
}
\author{
Zhonghui Huang
}
