% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dBetaBinom.R
\name{dBetaBinom}
\alias{dBetaBinom}
\alias{nimBetaFun}
\alias{dBetaBinom_v}
\alias{dBetaBinom_s}
\alias{rBetaBinom_v}
\alias{rBetaBinom_s}
\title{A beta binomial distribution and beta function for use in \code{nimble} models}
\usage{
nimBetaFun(a, b, log)

dBetaBinom_v(x, N, shape1, shape2, len, log = 0)

dBetaBinom_s(x, N, shape1, shape2, len, log = 0)

rBetaBinom_v(n, N, shape1, shape2, len)

rBetaBinom_s(n, N, shape1, shape2, len)
}
\arguments{
\item{a}{shape1 argument of the beta function.}

\item{b}{shape2 argument of the beta function.}

\item{log}{TRUE or 1 to return log probability. FALSE or 0 to return
probability.}

\item{x}{vector of integer counts.}

\item{N}{number of trials, sometimes called "size".}

\item{shape1}{shape1 parameter of the beta distribution.}

\item{shape2}{shape2 parameter of the beta distribution.}

\item{len}{length of \code{x}.}

\item{n}{number of random draws, each returning a vector of length
\code{len}. Currently only \code{n = 1} is supported, but the argument
exists for standardization of "\code{r}" functions.}
}
\description{
\code{dBetaBinom_v} and \code{dBetaBinom_s} provide a beta binomial
distribution that can be used directly from R or in \code{nimble}
models. These are also used by beta binomial variations of dNmixture distributions.
\code{nimBetaFun} is the beta function.
}
\details{
These nimbleFunctions provide distributions that can be used
  directly in R or in \code{nimble} hierarchical models (via
  \code{\link[nimble]{nimbleCode}} and \code{\link[nimble]{nimbleModel}}).
  They are used by the beta-binomial variants of the N-mixture distributions
  (\code{\link{dNmixture}}).

The beta binomial is the marginal distribution of a  binomial distribution whose
probability follows a  beta distribution.

The probability mass function of the beta binomial is
\code{choose(N, x) * B(x + shape1, N - x + shape2) /
B(shape1, shape2)}, where \code{B(shape1, shape2)} is the beta function.

\code{nimBetaFun(shape1, shape2)} calculates \code{B(shape1, shape2)}.

The beta binomial distribution is provided in two forms. \code{dBetaBinom_v} and
is when \code{shape1} and \code{shape2} are vectors.
\code{dBetaBinom_s} is used when \code{shape1} and \code{shape2} are scalars.
In both cases, \code{x} is a vector.
}
\examples{
# Calculate a beta binomial probability with different shape1 and shape2 for each x[i]
dBetaBinom_v(x = c(4, 0, 0, 3), N = 10,
  shape1 = c(0.5, 0.5, 0.3, 0.5), shape2 = c(0.2, 0.4, 1, 1.2))
# or with constant shape1 and shape2
dBetaBinom_s(x = c(4, 0, 0, 3), N = 10, shape1 = 0.5, shape2 = 0.5, log = TRUE)
}
\seealso{
For beta binomial N-mixture models, see \code{\link{dNmixture}}.
  For documentation on the beta function, use \code{?stats::dbeta}
}
\author{
Ben Goldstein and Perry de Valpine
}
