% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Skater.R
\name{skater_game_report}
\alias{skater_game_report}
\title{Access various reports for a season, game type, and category for all
the skaters by game}
\usage{
skater_game_report(
  season = season_now(),
  game_type = game_type_now(),
  category = "summary"
)
}
\arguments{
\item{season}{integer in YYYYYYYY (e.g., 20242025); see \code{\link[=seasons]{seasons()}} for
reference}

\item{game_type}{integer in 1:3 (where 1 = pre-season, 2 = regular season, 3
= playoff/post-season) OR character of 'pre', 'regular', or
playoff'/'post'; see \code{\link[=seasons]{seasons()}} for reference; most functions will NOT
support pre-season}

\item{category}{character (e.g., 'puckPossessions'); see
\code{\link[=skater_report_configurations]{skater_report_configurations()}} for reference}
}
\value{
data.frame with one row per game per player
}
\description{
\code{skater_game_report()} retrieves various reports for a season, game type, and category for all the skaters by game as a \code{data.frame} where each row represents game per player and includes detail on game timeline state, period/clock progression, and matchup flow, player identity, role, handedness, and biographical profile, and production, workload, efficiency, and result-level performance outcomes.
}
\examples{
# May take >5s, so skip.
\donttest{possession_skater_game_report_playoff_20212022 <- 
  skater_game_report(
    season    = 20212022, 
    game_type = 3, 
    category  = 'puckPossessions'
  )}
}
